/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ShipDesignEditor;
import ftjava.gui.ssd.AreaDefenseFireControlWidget;
import ftjava.gui.ssd.BeamBatteryWidget;
import ftjava.gui.ssd.CargoHoldWidget;
import ftjava.gui.ssd.FTLDriveWidget;
import ftjava.gui.ssd.FighterBayWidget;
import ftjava.gui.ssd.FireControlWidget;
import ftjava.gui.ssd.KineticGunWidget;
import ftjava.gui.ssd.MainDriveWidget;
import ftjava.gui.ssd.MultipleKineticPenetratorPackWidget;
import ftjava.gui.ssd.NeedleBeamWidget;
import ftjava.gui.ssd.PlasmaBoltLauncherWidget;
import ftjava.gui.ssd.PointDefenseWidget;
import ftjava.gui.ssd.PulseTorpedoWidget;
import ftjava.gui.ssd.PulserWidget;
import ftjava.gui.ssd.SalvoMissileLauncherWidget;
import ftjava.gui.ssd.SalvoMissileMagazineWidget;
import ftjava.gui.ssd.SalvoMissileRackWidget;
import ftjava.gui.ssd.ScattergunWidget;
import ftjava.gui.ssd.ScreenWidget;
import ftjava.gui.ssd.SubmunitionPackWidget;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.ssd.VapourShroudWidget;
import ftjava.std.AreaDefenseFireControl;
import ftjava.std.BeamBattery;
import ftjava.std.CargoHold;
import ftjava.std.FTLDrive;
import ftjava.std.FighterBay;
import ftjava.std.FireControl;
import ftjava.std.KineticGun;
import ftjava.std.MainDrive;
import ftjava.std.MultipleKineticPenetratorPack;
import ftjava.std.NeedleBeam;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.PointDefense;
import ftjava.std.PulseTorpedo;
import ftjava.std.Pulser;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.SalvoMissileRack;
import ftjava.std.Scattergun;
import ftjava.std.Screen;
import ftjava.std.ShipSystem;
import ftjava.std.SubmunitionPack;
import ftjava.std.VapourShroud;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class SystemPallette
extends JFrame
implements WindowListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static SystemPallette SYSTEMS = new SystemPallette();
    private static JScrollPane palletteView;
    private static JPanel pallette;
    private static JToolBar tools;
    private static ButtonGroup toolBarButtonGroup;
    private static SystemWidget currentSystem;
    private static JPanel currentSystemPanel;
    private static ShipDesignEditor currentShip;
    private static ArrayList loadedWidgets;

    private SystemPallette() {
        super("Systems");
        tools = new JToolBar();
        toolBarButtonGroup = new ButtonGroup();
        JRadioButton tb = new JRadioButton("+", true);
        tb.setActionCommand("add");
        toolBarButtonGroup.add(tb);
        tools.add(tb);
        tb = new JRadioButton("-");
        tb.setActionCommand("remove");
        tb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                SystemPallette.this.updateRemoveSystemListeners(ie.getStateChange());
            }
        });
        toolBarButtonGroup.add(tb);
        tools.add(tb);
        this.getContentPane().add((Component)tools, "North");
        pallette = new JPanel();
        pallette.setLayout(new BoxLayout(pallette, 1));
        SystemPallette.addSystems();
        palletteView = new JScrollPane(pallette, 22, 31);
        this.getContentPane().add((Component)palletteView, "Center");
        this.pack();
        this.setSize(this.getWidth(), 450);
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
        try {
            String toolCommand = toolBarButtonGroup.getSelection().getActionCommand();
            if (currentShip != null) {
                currentShip.getSSD().removeMouseListener(this);
                if (toolCommand.equals("remove")) {
                    this.updateRemoveSystemListeners(2);
                }
            }
            currentShip = (ShipDesignEditor)e.getComponent();
            currentShip.getSSD().addMouseListener(this);
            if (toolCommand.equals("remove")) {
                this.updateRemoveSystemListeners(1);
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        String command = toolBarButtonGroup.getSelection().getActionCommand();
        if (command.equals("add")) {
            if (currentSystem != null && currentShip != null) {
                try {
                    ShipSystem sysCopy = (ShipSystem)currentSystem.getShipSystem().getClass().newInstance();
                    sysCopy.setXSSD(e.getX());
                    sysCopy.setYSSD(e.getY());
                    currentShip.getSSD().addSystem(sysCopy);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else if (command.equals("remove") && currentShip != null && e.getComponent() instanceof SystemWidget) {
            SystemWidget theSys = (SystemWidget)e.getComponent();
            currentShip.getSSD().removeSystem(theSys);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void updateRemoveSystemListeners(int removeState) {
        block2: {
            Component[] ssdWidgets;
            block3: {
                if (currentShip == null) break block2;
                ssdWidgets = currentShip.getSSD().getComponents();
                if (removeState != 1) break block3;
                for (int i = 0; i < ssdWidgets.length; ++i) {
                    ssdWidgets[i].addMouseListener(SYSTEMS);
                }
                break block2;
            }
            if (removeState != 2) break block2;
            for (int i = 0; i < ssdWidgets.length; ++i) {
                ssdWidgets[i].removeMouseListener(SYSTEMS);
            }
        }
    }

    private static void addSystems() {
        int i;
        if (loadedWidgets == null) {
            loadedWidgets = new ArrayList();
        }
        SystemPalletteListener ml = new SystemPalletteListener();
        SystemWidget sw = new MainDriveWidget(new MainDrive(), false);
        loadedWidgets.add(sw);
        sw = new FTLDriveWidget(new FTLDrive(), false);
        loadedWidgets.add(sw);
        sw = new BeamBatteryWidget(new BeamBattery(), false);
        sw.addMouseListener(ml);
        loadedWidgets.add(sw);
        sw = new PulseTorpedoWidget(new PulseTorpedo(), false);
        loadedWidgets.add(sw);
        sw = new NeedleBeamWidget(new NeedleBeam(), false);
        loadedWidgets.add(sw);
        sw = new SalvoMissileRackWidget(new SalvoMissileRack(), false);
        loadedWidgets.add(sw);
        sw = new SalvoMissileLauncherWidget(new SalvoMissileLauncher(), false);
        loadedWidgets.add(sw);
        sw = new SalvoMissileMagazineWidget(new SalvoMissileMagazine(2), false);
        loadedWidgets.add(sw);
        sw = new SubmunitionPackWidget(new SubmunitionPack(), false);
        loadedWidgets.add(sw);
        sw = new PointDefenseWidget(new PointDefense(), false);
        loadedWidgets.add(sw);
        sw = new FireControlWidget(new FireControl(), false);
        loadedWidgets.add(sw);
        sw = new AreaDefenseFireControlWidget(new AreaDefenseFireControl(), false);
        loadedWidgets.add(sw);
        sw = new ScreenWidget(new Screen(), false);
        loadedWidgets.add(sw);
        sw = new VapourShroudWidget(new VapourShroud(), false);
        loadedWidgets.add(sw);
        sw = new PulserWidget(new Pulser(), false);
        loadedWidgets.add(sw);
        sw = new PlasmaBoltLauncherWidget(new PlasmaBoltLauncher(), false);
        loadedWidgets.add(sw);
        sw = new KineticGunWidget(new KineticGun(), false);
        loadedWidgets.add(sw);
        sw = new MultipleKineticPenetratorPackWidget(new MultipleKineticPenetratorPack(), false);
        loadedWidgets.add(sw);
        sw = new ScattergunWidget(new Scattergun(), false);
        loadedWidgets.add(sw);
        sw = new FighterBayWidget(new FighterBay(), false);
        loadedWidgets.add(sw);
        sw = new CargoHoldWidget(new CargoHold(), false);
        loadedWidgets.add(sw);
        Dimension maxSize = new Dimension(0, 0);
        for (i = 0; i < loadedWidgets.size(); ++i) {
            sw = (SystemWidget)loadedWidgets.get(i);
            if (sw.getWidth() > maxSize.width) {
                maxSize.width = sw.getWidth();
            }
            if (sw.getHeight() <= maxSize.height) continue;
            maxSize.height = sw.getHeight();
        }
        for (i = 0; i < loadedWidgets.size(); ++i) {
            sw = (SystemWidget)loadedWidgets.get(i);
            JPanel p = new JPanel();
            p.setSize(maxSize);
            p.add((Component)sw, "Center");
            sw.addMouseListener(ml);
            p.addMouseListener(ml);
            pallette.add(p);
        }
    }

    static {
        currentSystem = null;
        currentSystemPanel = null;
        currentShip = null;
    }

    private static class SystemPalletteListener
    extends MouseAdapter {
        private static Border noBorder = BorderFactory.createEmptyBorder();
        private static Border selectedBorder = BorderFactory.createLineBorder(Color.black);

        private SystemPalletteListener() {
        }

        public void mouseClicked(MouseEvent me) {
            Component clickedComponent = me.getComponent();
            if (clickedComponent instanceof JPanel) {
                JPanel clickedWidget = (JPanel)clickedComponent;
                Component[] components = clickedWidget.getComponents();
                if (currentSystem != null) {
                    currentSystemPanel.setBorder(noBorder);
                }
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof SystemWidget)) continue;
                    currentSystem = (SystemWidget)components[i];
                    currentSystemPanel = clickedWidget;
                    break;
                }
                currentSystemPanel.setBorder(selectedBorder);
            } else if (clickedComponent instanceof SystemWidget) {
                SystemWidget clickedWidget = (SystemWidget)clickedComponent;
                if (currentSystemPanel != null) {
                    currentSystemPanel.setBorder(noBorder);
                }
                currentSystem = clickedWidget;
                currentSystemPanel = (JPanel)clickedWidget.getParent();
                currentSystemPanel.setBorder(selectedBorder);
            }
        }
    }
}

