/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.std.LogRecord;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextSpaceObjectLog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextArea TextArea;
    private JScrollPane ScrollPane;
    private SpaceObject spaceObject;
    private ArrayList theLog;

    public TextSpaceObjectLog(SpaceObject inSpaceObj) {
        super(inSpaceObj.getName());
        this.spaceObject = inSpaceObj;
        this.theLog = this.spaceObject.getLog();
        this.TextArea = new JTextArea();
        this.TextArea.setText(this.logToString() + "\n");
        this.update();
        this.pack();
        String borderString = "Log";
        if (this.spaceObject instanceof Ship) {
            borderString = "Ship's Log";
        }
        this.ScrollPane = new JScrollPane(this.TextArea);
        this.ScrollPane.setBorder(BorderFactory.createTitledBorder(borderString));
        this.ScrollPane.setPreferredSize(new Dimension(600, 200));
        this.getContentPane().add(this.ScrollPane);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.setSize(2 * screenWidth / 3, screenHeight / 4);
        this.setLocation(0, screenHeight / 2);
        this.setVisible(true);
    }

    public void setObject(SpaceObject inSpaceObj) {
        this.spaceObject = inSpaceObj;
        this.setTitle(this.spaceObject.getName());
        this.update();
    }

    public void update() {
        String input = this.logToString() + "\n";
        if (this.spaceObject instanceof Ship) {
            input = input + ((Ship)this.spaceObject).getAllNotes();
        }
        this.TextArea.setText(input);
    }

    public String logToString() {
        StringBuffer s = new StringBuffer();
        String one = " ";
        LogRecord l = null;
        s.append(one);
        if (this.spaceObject instanceof Ship) {
            s.append("Ship's Log\n");
        } else {
            s.append("\n");
        }
        if (this.theLog.size() > 0) {
            for (int i = 0; i < this.theLog.size(); ++i) {
                l = (LogRecord)this.theLog.get(i);
                s.append(l);
                s.append("\n");
            }
        }
        return s.toString();
    }
}

