/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.Armor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ArmorWidget
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Armor theArmor;
    private boolean mutable;
    private Dimension bounds;
    private static final Ellipse2D ellipse = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
    private static final Ellipse2D smallDot = new Ellipse2D.Double(0.0, 0.0, 3.0, 3.0);
    private static final int OK = 0;
    private static final int DESTROYED = 1;

    public ArmorWidget(Armor h) {
        this(h, false);
    }

    public ArmorWidget() {
        this(new Armor(), true);
    }

    public ArmorWidget(Armor h, boolean m) {
        this.theArmor = h;
        this.mutable = m;
        int numShells = this.theArmor.getArmorShellCount();
        this.bounds = new Dimension(0, 0);
        this.setLayout(null);
        for (int i = numShells - 1; i >= 0; --i) {
            this.add(new ArmorShellWidget(i));
        }
        this.setDimensions();
        this.setToolTipText(this.getToolTip());
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if (ac.equals("add")) {
            int shell = this.theArmor.getArmorShellCount();
            this.theArmor.setTotalArmor(0, shell);
            ArmorShellWidget w = new ArmorShellWidget(shell);
            this.add(w);
            this.setDimensions();
            Point loc = this.getLocation();
            loc.y -= 14;
            this.setLocation(loc);
        } else if (ac.equals("remove")) {
            // empty if block
        }
        this.repaint();
    }

    private static void drawArmor(Graphics2D g, int c) {
        g.setColor(Color.white);
        g.fill(ellipse);
        g.setColor(Color.black);
        if (c == 1) {
            g.fill(ellipse);
        }
        g.draw(ellipse);
    }

    public void setDimensions() {
        ArmorShellWidget asw;
        int i;
        Component[] c = this.getComponents();
        this.bounds.width = 0;
        this.bounds.height = 0;
        for (i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof ArmorShellWidget)) continue;
            asw = (ArmorShellWidget)c[i];
            asw.setDimensions();
            if (asw.bounds.width > this.bounds.width) {
                this.bounds.width = asw.bounds.width;
            }
            this.bounds.height += asw.bounds.height;
        }
        for (i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof ArmorShellWidget)) continue;
            asw = (ArmorShellWidget)c[i];
            asw.setLocation(0, this.bounds.height - (asw.shell + 1) * asw.bounds.height);
        }
        this.setMinimumSize(this.bounds);
        this.setPreferredSize(this.bounds);
        this.setMaximumSize(this.bounds);
        this.setSize(this.bounds);
    }

    public void paintComponent(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        Paint oldPaint = g.getPaint();
        Rectangle r = this.getBounds(null);
        g.setPaint(SSDDrawingTools.backgroundPaint);
        g.fill(r);
        g.setPaint(oldPaint);
    }

    private String getToolTip() {
        return "Armor: " + this.theArmor.getRemainingArmor() + "/" + this.theArmor.getTotalArmor();
    }

    private class ArmorShellWidget
    extends JComponent
    implements MouseListener,
    ActionListener {
        private static final long serialVersionUID = 1L;
        int shell;
        Dimension bounds;
        private JPopupMenu popup;
        private JMenuItem addShell;
        private JMenuItem removeShell;
        private JMenuItem increase;
        private JMenuItem decrease;
        private JMenuItem value;

        public ArmorShellWidget(int shell) {
            this.shell = shell;
            this.bounds = new Dimension(0, 0);
            this.setDimensions();
            if (ArmorWidget.this.mutable) {
                this.initialiseArmorMenu();
                this.addMouseListener(this);
            }
        }

        public void paint(Graphics g_o) {
            Graphics2D g = (Graphics2D)g_o;
            AffineTransform lastT = g.getTransform();
            int numArmor = ArmorWidget.this.theArmor.getTotalArmor(this.shell);
            int numArmorDamaged = numArmor - ArmorWidget.this.theArmor.getRemainingArmor(this.shell);
            g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
            g.translate(2, 2);
            for (int i = 0; i < numArmor; ++i) {
                if (numArmorDamaged > 0) {
                    ArmorWidget.drawArmor(g, 1);
                    --numArmorDamaged;
                } else {
                    ArmorWidget.drawArmor(g, 0);
                }
                g.translate(12, 0);
            }
            if (ArmorWidget.this.mutable && numArmor == 0) {
                g.setColor(Color.darkGray);
                g.fill(smallDot);
            }
            g.setTransform(lastT);
        }

        private void setDimensions() {
            int max_col = ArmorWidget.this.theArmor.getTotalArmor(this.shell);
            this.bounds.height = 14;
            this.bounds.width = max_col > 0 ? max_col * 10 + (max_col + 1) * 2 : 14;
            this.setMinimumSize(this.bounds);
            this.setPreferredSize(this.bounds);
            this.setMaximumSize(this.bounds);
            this.setSize(this.bounds);
        }

        public void actionPerformed(ActionEvent ae) {
            int newRating;
            String ac = ae.getActionCommand();
            if (ac.equals("increase")) {
                ArmorWidget.this.theArmor.setTotalArmor(ArmorWidget.this.theArmor.getTotalArmor(this.shell) + 1, this.shell);
            } else if (ac.equals("decrease")) {
                if (ArmorWidget.this.theArmor.getTotalArmor(this.shell) > 0) {
                    ArmorWidget.this.theArmor.setTotalArmor(ArmorWidget.this.theArmor.getTotalArmor(this.shell) - 1, this.shell);
                }
            } else if (ac.equals("armor") && (newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), ArmorWidget.this.theArmor.getTotalArmor(this.shell))) >= 0) {
                ArmorWidget.this.theArmor.setTotalArmor(newRating, this.shell);
            }
            this.setToolTipText(ArmorWidget.this.getToolTip());
            ArmorWidget.this.setDimensions();
            ArmorWidget.this.repaint();
        }

        public void mouseClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.popup.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.mousePressed(me);
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        private void initialiseArmorMenu() {
            if (this.popup != null) {
                return;
            }
            this.popup = new JPopupMenu();
            this.addShell = new JMenuItem("Add Shell");
            this.addShell.setActionCommand("add");
            this.addShell.addActionListener(ArmorWidget.this);
            this.removeShell = new JMenuItem("Remove Shell");
            this.removeShell.setActionCommand("remove");
            this.increase = new JMenuItem("Increase");
            this.increase.setActionCommand("increase");
            this.decrease = new JMenuItem("Decrease");
            this.decrease.setActionCommand("decrease");
            this.value = new JMenuItem("Armor Value...");
            this.value.setActionCommand("armor");
            this.increase.addActionListener(this);
            this.decrease.addActionListener(this);
            this.value.addActionListener(this);
            this.popup.add(this.increase);
            this.popup.add(this.decrease);
            this.popup.add(this.value);
            this.popup.add(this.addShell);
        }
    }
}

