/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.MainDrive;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class MainDriveWidget
extends SystemWidget {
    public static final Dimension MAINDRIVE_SIZE = new Dimension(31, 26);
    private static final GeneralPath standardDriveOutline = new GeneralPath();
    private static final GeneralPath advancedDriveOutline;

    public MainDriveWidget() {
        this(new MainDrive(), true);
    }

    public MainDriveWidget(MainDrive ftl) {
        this(ftl, false);
    }

    public MainDriveWidget(MainDrive ftl, boolean m) {
        super(ftl, m);
        this.setPreferredSize(MAINDRIVE_SIZE);
        this.setMinimumSize(MAINDRIVE_SIZE);
        this.setMaximumSize(MAINDRIVE_SIZE);
        this.setSize(MAINDRIVE_SIZE);
        this.setToolTipText(this.getToolTip());
        this.removeMouseMotionListener(this);
        if (this.mutable) {
            this.initialiseDriveMenu();
        }
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int size = ((MainDrive)this.theSystem).getInitialThrust();
        String type = ((MainDrive)this.theSystem).getType();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        if (type.equals("Advanced")) {
            this.drawAdvancedDrive(g, size);
        } else {
            this.drawStandardDrive(g, size);
        }
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        MainDrive md = (MainDrive)this.theSystem;
        if (ac.equals("Advanced") || ac.equals("Standard")) {
            md.setType(ac);
        } else if (ac.equals("other")) {
            int newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), md.getInitialThrust());
            if (newRating >= 0) {
                md.setInitialThrust(newRating);
            }
        } else {
            try {
                md.setValue("rating", ac);
            }
            catch (NumberFormatException nfe) {
                this.repaint();
                return;
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void drawStandardDrive(Graphics2D g, int size) {
        g.setColor(Color.white);
        g.fill(standardDriveOutline);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(standardDriveOutline);
        String thrust = Integer.toString(size);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(thrust, 15 - fm.stringWidth(thrust) / 2, 20);
    }

    private void drawAdvancedDrive(Graphics2D g, int size) {
        g.setColor(Color.white);
        g.fill(advancedDriveOutline);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(advancedDriveOutline);
        String thrust = Integer.toString(size);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(thrust, 15 - fm.stringWidth(thrust) / 2, 18);
    }

    private void initialiseDriveMenu() {
        JRadioButtonMenuItem mi;
        try {
            this.popup.remove(0);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        MainDrive md = (MainDrive)this.theSystem;
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem("Standard", md.getType().equals("Standard"));
        rbmi.setActionCommand("Standard");
        rbmi.addActionListener(this);
        bg.add(rbmi);
        this.popup.add(rbmi);
        rbmi = new JRadioButtonMenuItem("Advanced", md.getType().equals("Advanced"));
        rbmi.setActionCommand("Advanced");
        rbmi.addActionListener(this);
        bg.add(rbmi);
        this.popup.add(rbmi);
        this.popup.addSeparator();
        JMenu m = new JMenu("Thrust");
        bg = new ButtonGroup();
        int initialThrust = md.getInitialThrust();
        for (int i = 1; i <= 8; ++i) {
            String c = Integer.toString(i);
            mi = new JRadioButtonMenuItem(c, i == initialThrust);
            mi.setActionCommand(c);
            mi.addActionListener(this);
            bg.add(mi);
            m.add(mi);
        }
        mi = new JRadioButtonMenuItem("Other...", false);
        mi.setActionCommand("other");
        mi.addActionListener(this);
        bg.add(mi);
        m.add(mi);
        this.popup.add(m);
    }

    private String getToolTip() {
        MainDrive d = (MainDrive)this.theSystem;
        return d.getType() + " Drive (" + d.getCurrentThrust() + "/" + d.getInitialThrust() + ")";
    }

    static {
        standardDriveOutline.reset();
        standardDriveOutline.moveTo(0.0f, 25.0f);
        standardDriveOutline.lineTo(0.0f, 10.0f);
        standardDriveOutline.lineTo(15.0f, 0.0f);
        standardDriveOutline.lineTo(30.0f, 10.0f);
        standardDriveOutline.lineTo(30.0f, 25.0f);
        standardDriveOutline.closePath();
        advancedDriveOutline = new GeneralPath();
        advancedDriveOutline.reset();
        advancedDriveOutline.moveTo(0.0f, 7.0f);
        advancedDriveOutline.lineTo(0.0f, 18.0f);
        advancedDriveOutline.lineTo(15.0f, 25.0f);
        advancedDriveOutline.lineTo(30.0f, 18.0f);
        advancedDriveOutline.lineTo(30.0f, 7.0f);
        advancedDriveOutline.lineTo(15.0f, 0.0f);
        advancedDriveOutline.closePath();
    }
}

