/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.MultipleKineticPenetratorPack;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class MultipleKineticPenetratorPackWidget
extends SystemWidget {
    private static final Dimension MKP_SIZE = new Dimension(21, 31);
    private static final GeneralPath hexPath;
    private static final GeneralPath triPath;
    private static float h;

    public MultipleKineticPenetratorPackWidget() {
        this(new MultipleKineticPenetratorPack(), true);
    }

    public MultipleKineticPenetratorPackWidget(MultipleKineticPenetratorPack mkp) {
        this(mkp, false);
    }

    public MultipleKineticPenetratorPackWidget(MultipleKineticPenetratorPack mkp, boolean m) {
        super(mkp, m);
        this.setPreferredSize(MKP_SIZE);
        this.setMinimumSize(MKP_SIZE);
        this.setMaximumSize(MKP_SIZE);
        this.setSize(MKP_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        AffineTransform lastTransform = g.getTransform();
        boolean isForwardFacing = true;
        int fireArcs = ((Weapon)this.theSystem).getArcs();
        if ((fireArcs & Weapon.AFT_ARCS) != 0) {
            isForwardFacing = false;
        }
        g.translate(10, 10 + (isForwardFacing ? 10 : 0));
        g.setColor(Color.white);
        g.fill(hexPath);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(hexPath);
        fireArcs >>= 21;
        for (int i = 0; i < 6 && (fireArcs >> i & 1) == 0; ++i) {
            g.rotate(-1.0471975511965976);
        }
        g.fill(triPath);
        g.draw(triPath);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    private String getToolTip() {
        MultipleKineticPenetratorPack mkp = (MultipleKineticPenetratorPack)this.theSystem;
        return "Multiple Kinetic Penetrator Pack " + mkp.getArcsString();
    }

    static {
        h = (float)(10.0 * Math.sqrt(3.0) / 2.0);
        hexPath = new GeneralPath();
        hexPath.reset();
        hexPath.moveTo(-5.0f, h);
        hexPath.lineTo(5.0f, h);
        hexPath.lineTo(10.0f, 0.0f);
        hexPath.lineTo(5.0f, -h);
        hexPath.lineTo(-5.0f, -h);
        hexPath.lineTo(-10.0f, 0.0f);
        hexPath.closePath();
        triPath = new GeneralPath();
        triPath.reset();
        triPath.moveTo(0.0f, 0.0f);
        triPath.lineTo(-5.0f, 20.0f);
        triPath.lineTo(5.0f, 20.0f);
        triPath.closePath();
    }
}

