/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.NeedleBeam;
import ftjava.std.Weapon;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class NeedleBeamWidget
extends SystemWidget {
    private static final Dimension NEEDLEBEAM_SIZE = new Dimension(21, 36);
    private static final Line2D needleLine = new Line2D.Double(0.0, 0.0, 0.0, 20.0);
    private static final Ellipse2D bodyEllipse = new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0);
    private static final BasicStroke needleStroke = new BasicStroke(5.0f, 1, 1);

    public NeedleBeamWidget() {
        this(new NeedleBeam(), true);
    }

    public NeedleBeamWidget(NeedleBeam mkp) {
        this(mkp, false);
    }

    public NeedleBeamWidget(NeedleBeam mkp, boolean m) {
        super(mkp, m);
        this.setPreferredSize(NEEDLEBEAM_SIZE);
        this.setMinimumSize(NEEDLEBEAM_SIZE);
        this.setMaximumSize(NEEDLEBEAM_SIZE);
        this.setSize(NEEDLEBEAM_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        int i;
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        AffineTransform lastTransform = g.getTransform();
        boolean isForwardFacing = true;
        int fireArcs = ((Weapon)this.theSystem).getArcs();
        fireArcs >>= 21;
        for (i = 0; i < 6 && (fireArcs >> i & 1) == 0; ++i) {
        }
        if (i >= 2 && i <= 4) {
            g.translate(10, 25);
        } else {
            g.translate(10, 10);
        }
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.fill(bodyEllipse);
        Stroke lastStroke = g.getStroke();
        g.setStroke(needleStroke);
        g.rotate((double)(-60 * i) * Math.PI / 180.0);
        g.draw(needleLine);
        g.setStroke(lastStroke);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    private String getToolTip() {
        NeedleBeam theBeam = (NeedleBeam)this.theSystem;
        return "Needle Beam " + theBeam.getArcsString();
    }
}

