/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.NovaCannon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class NovaCannonWidget
extends SystemWidget {
    private static final Dimension NOVA_CANNON_SIZE = new Dimension(40, 40);

    public NovaCannonWidget() {
        this(new NovaCannon(), true);
    }

    public NovaCannonWidget(NovaCannon nc) {
        this(nc, false);
    }

    public NovaCannonWidget(NovaCannon nc, boolean mutable) {
        super(nc, mutable);
        this.setMinimumSize(NOVA_CANNON_SIZE);
        this.setMaximumSize(NOVA_CANNON_SIZE);
        this.setPreferredSize(NOVA_CANNON_SIZE);
        this.setSize(NOVA_CANNON_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.translate(20, 20);
        Ellipse2D.Double ell1 = new Ellipse2D.Double(-10.0, -15.0, 20.0, 20.0);
        Ellipse2D.Double ell2 = new Ellipse2D.Double(-7.0, -2.0, 14.0, 14.0);
        Ellipse2D.Double ell3 = new Ellipse2D.Double(-4.0, 8.0, 8.0, 8.0);
        g.setColor(Color.white);
        g.fill(ell1);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ell1);
        g.setColor(Color.white);
        g.fill(ell2);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ell2);
        g.setColor(Color.white);
        g.fill(ell3);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ell3);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        this.repaint();
    }

    private String getToolTip() {
        return "Nova Cannon";
    }
}

