/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.SalvoMissileLauncher;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class SalvoMissileLauncherWidget
extends SystemWidget {
    private static final Dimension SML_SIZE = new Dimension(31, 31);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 180.0, 60.0, 2);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 120.0, 60.0, 2);
    private static final Ellipse2D CENTER_AREA = new Ellipse2D.Double(5.0, 5.0, 20.0, 20.0);
    private static final Arc2D arc = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Ellipse2D ellipse = new Ellipse2D.Double(5.0, 5.0, 20.0, 20.0);
    private static final GeneralPath missileIcon = new GeneralPath();

    public SalvoMissileLauncherWidget(SalvoMissileLauncher sml) {
        this(sml, false);
    }

    public SalvoMissileLauncherWidget() {
        this(new SalvoMissileLauncher(), true);
    }

    public SalvoMissileLauncherWidget(SalvoMissileLauncher sml, boolean mutable) {
        super(sml, mutable);
        this.initialiseSMLMenuItems();
        this.setMinimumSize(SML_SIZE);
        this.setMaximumSize(SML_SIZE);
        this.setPreferredSize(SML_SIZE);
        this.setSize(SML_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
                g.fill(arc);
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
                g.draw(arc);
            }
            g.rotate(-1.0471975511965976, 15.0, 15.0);
        }
        g.setColor(Color.white);
        g.fill(ellipse);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ellipse);
        g.draw(missileIcon);
        g.fill(missileIcon);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        SalvoMissileLauncher theSML = (SalvoMissileLauncher)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                theSML.setArcs(theSML.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        SalvoMissileLauncher theSML = (SalvoMissileLauncher)this.theSystem;
        String ac = ae.getActionCommand();
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialiseSMLMenuItems() {
        if (this.mutable) {
            // empty if block
        }
    }

    private String getToolTip() {
        SalvoMissileLauncher sml = (SalvoMissileLauncher)this.theSystem;
        return "Salvo Missile Launcher " + sml.getArcsString();
    }

    static {
        missileIcon.reset();
        missileIcon.moveTo(15.0f, 7.0f);
        missileIcon.lineTo(10.0f, 22.0f);
        missileIcon.lineTo(15.0f, 19.0f);
        missileIcon.lineTo(20.0f, 22.0f);
        missileIcon.closePath();
    }
}

