/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.WaveGun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class WaveGunWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension WAVE_GUN_SIZE = new Dimension(40, 50);
    private static final GeneralPath path = new GeneralPath();

    public WaveGunWidget(WaveGun wg) {
        this(wg, false);
    }

    public WaveGunWidget() {
        this(new WaveGun(), true);
    }

    public WaveGunWidget(WaveGun wg, boolean mutable) {
        super(wg, mutable);
        this.setMinimumSize(WAVE_GUN_SIZE);
        this.setMaximumSize(WAVE_GUN_SIZE);
        this.setPreferredSize(WAVE_GUN_SIZE);
        this.setSize(WAVE_GUN_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(Color.white);
        g.fill(path);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(path);
        g.translate(20, 17);
        Ellipse2D.Double ell1 = new Ellipse2D.Double(-7.0, -10.0, 14.0, 14.0);
        Ellipse2D.Double ell2 = new Ellipse2D.Double(-5.0, 2.0, 10.0, 10.0);
        Ellipse2D.Double ell3 = new Ellipse2D.Double(-3.0, 11.0, 6.0, 6.0);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.fill(ell1);
        g.fill(ell2);
        g.fill(ell3);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        this.repaint();
    }

    private String getToolTip() {
        return "Wave Gun";
    }

    static {
        path.reset();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(39.0f, 0.0f);
        path.lineTo(19.0f, 49.0f);
        path.closePath();
    }
}

