/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SystemWidget;
import ftjava.std.ShipSystem;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class WidgetFactory {
    private static HashMap foundSystems = new HashMap();

    static SystemWidget createWidgetFromSystem(ShipSystem theSystem, boolean mutable) {
        SystemWidget theWidget;
        String systemType = theSystem.getClass().getName();
        Class widgetClass = null;
        if (foundSystems.containsKey(theSystem)) {
            widgetClass = (Class)foundSystems.get(systemType);
        } else {
            widgetClass = WidgetFactory.deepSearch(systemType);
            if (widgetClass == null) {
                return null;
            }
            foundSystems.put(theSystem, widgetClass);
        }
        Constructor c = null;
        try {
            c = widgetClass.getConstructor(theSystem.getClass(), Boolean.TYPE);
        }
        catch (NoSuchMethodException nsm) {
            System.out.println("No valid constructor for " + widgetClass);
            return null;
        }
        Object[] args = new Object[]{theSystem, new Boolean(mutable)};
        try {
            theWidget = (SystemWidget)c.newInstance(args);
        }
        catch (Exception e) {
            return null;
        }
        if (theSystem.getXSSD() >= 0 && theSystem.getYSSD() >= 0) {
            theWidget.setLocation(theSystem.getXSSD() - theWidget.getWidth() / 2, theSystem.getYSSD() - theWidget.getHeight() / 2);
        }
        return theWidget;
    }

    private static Class deepSearch(String systemType) {
        int classNameIndex = systemType.lastIndexOf(46);
        String systemClassName = classNameIndex >= 0 ? systemType.substring(classNameIndex + 1) : systemType;
        String widgetClassName = systemClassName + "Widget";
        Class<?> widgetClass = null;
        try {
            widgetClass = Class.forName("ftjava.gui.ssd." + widgetClassName);
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        try {
            widgetClass = Class.forName("ftjava.gui.ssd.variant." + widgetClassName);
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        if (widgetClass == null) {
            try {
                widgetClass = Class.forName(widgetClassName);
            }
            catch (ClassNotFoundException cnf) {
                System.out.println("No class " + widgetClassName + " found.");
                return null;
            }
        }
        return widgetClass;
    }
}

