/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd.variant;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.StealthGenerator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class StealthGeneratorWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension SCREEN_SIZE = new Dimension(14, 22);
    private static final Arc2D topArc = new Arc2D.Double(-6.0, 2.0, 22.0, 22.0, 70.0, 40.0, 0);
    private static final Arc2D botArc = new Arc2D.Double(-3.0, 5.0, 16.0, 16.0, 70.0, 40.0, 0);
    private static final GeneralPath hexagon = new GeneralPath();

    public StealthGeneratorWidget(StealthGenerator s) {
        this(s, false);
    }

    public StealthGeneratorWidget() {
        this(new StealthGenerator(), true);
    }

    public StealthGeneratorWidget(StealthGenerator s, boolean m) {
        super(s, m);
        this.setMinimumSize(SCREEN_SIZE);
        this.setMaximumSize(SCREEN_SIZE);
        this.setPreferredSize(SCREEN_SIZE);
        this.setSize(SCREEN_SIZE);
        this.setToolTipText("StealthGenerator");
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform lastT = g.getTransform();
        g.translate(2, 2);
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.fill(hexagon);
        g.draw(botArc);
        g.draw(topArc);
        SSDDrawingTools.indicateStatus(g, this);
        g.setTransform(lastT);
    }

    static {
        hexagon.reset();
        hexagon.moveTo(3.0f, 8.0f);
        hexagon.lineTo(8.0f, 8.0f);
        hexagon.lineTo(11.0f, 13.0f);
        hexagon.lineTo(8.0f, 18.0f);
        hexagon.lineTo(3.0f, 18.0f);
        hexagon.lineTo(0.0f, 13.0f);
        hexagon.closePath();
    }
}

