/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JButton;

public class ImageUtilities {
    public static Hashtable IconTable = new Hashtable();

    public static BufferedImage getShipImage(String name, Color color) {
        JButton b = new JButton();
        BufferedImage image = null;
        BufferedImage mask = null;
        image = ImageUtilities.getImage(name + ".png", b);
        if (image == null) {
            image = ImageUtilities.getImage(name + ".gif", b);
        }
        if (image == null) {
            return image;
        }
        mask = ImageUtilities.getImage(name + "Mask.png", b);
        if (image != null && mask != null) {
            Graphics2D g = image.createGraphics();
            g.setComposite(AlphaComposite.DstOver);
            g.setColor(color);
            g.fill(new Rectangle(0, 0, 2 * image.getWidth(null), 2 * image.getHeight(null)));
            g.setComposite(AlphaComposite.DstIn);
            g.drawImage(mask, null, null);
        }
        return image;
    }

    public static BufferedImage getImage(String name, Component component) {
        BufferedImage bImage = null;
        bImage = (BufferedImage)IconTable.get(name);
        if (bImage != null) {
            return bImage;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            return null;
        }
        Image image = tk.getImage(url);
        MediaTracker tracker = new MediaTracker(component);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        bImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bImage.createGraphics().drawImage(image, null, null);
        IconTable.put(name, bImage);
        return bImage;
    }
}

