/*
 * Decompiled with CFR 0.152.
 */
package ftjava.mailman;

import ftjava.mailman.MailPasswordDialog;
import ftjava.util.UserPreferences;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.swing.ProgressMonitor;

public class FetchClientEmail {
    public static String fetchMail() throws Exception {
        String protocol = UserPreferences.getPreferences().getProperty("Mail Protocol");
        Properties props = new Properties();
        props.setProperty("mail.user", UserPreferences.getPreferences().getProperty("Mail Username"));
        props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("Email Address"));
        props.setProperty("mail.store.protocol", protocol);
        props.setProperty("mail." + protocol + ".host", UserPreferences.getPreferences().getProperty("Mail Host"));
        props.setProperty("mail." + protocol + ".user", UserPreferences.getPreferences().getProperty("Mail Username"));
        String host = UserPreferences.getPreferences().getProperty("Mail Host");
        String user = UserPreferences.getPreferences().getProperty("Mail Username");
        String password = UserPreferences.getPreferences().getProperty("Mail Password");
        String message = "No games fetched from the Mailbox.";
        String sep = System.getProperty("line.separator");
        String indent = "    ";
        boolean found = false;
        Session session = null;
        session = user.equals("") && password.equals("") ? Session.getInstance((Properties)props, (Authenticator)new MailPasswordDialog()) : (password.equals("") ? Session.getInstance((Properties)props, (Authenticator)new MailPasswordDialog(user)) : Session.getInstance((Properties)props, null));
        Store store = session.getStore();
        session.setDebug(false);
        try {
            store.connect(host, user, password);
        }
        catch (AuthenticationFailedException e1) {
            message = "Failed to open mailbox on " + host + " as " + user;
            System.err.println(message);
            return message;
        }
        Folder folder = store.getDefaultFolder();
        folder = folder.getFolder(UserPreferences.getPreferences().getProperty("Mail Folder"));
        folder.open(2);
        Flags flags = new Flags();
        flags.add(Flags.Flag.FLAGGED);
        HeaderTerm headerterm = new HeaderTerm("FTJava-PBEM", "");
        Message[] messages = folder.search((SearchTerm)headerterm);
        messages = folder.getMessages();
        ProgressMonitor progress = new ProgressMonitor(null, "Fetching email from server", "", 0, messages.length - 1);
        boolean delete = Boolean.valueOf(UserPreferences.getPreferences().getProperty("Delete Fetched Email"));
        for (int i = 0; i < messages.length; ++i) {
            progress.setProgress(i);
            progress.setNote("Message " + (i + 1) + "/" + messages.length);
            HashMap games = new HashMap();
            boolean saved = true;
            if (!FetchClientEmail.processContent(messages[i].getContent(), games)) continue;
            Iterator keys = games.keySet().iterator();
            while (keys.hasNext()) {
                String filename = (String)keys.next();
                Object contents = games.get(filename);
                try {
                    Closeable fout;
                    File directory = new File(UserPreferences.getPreferences().getProperty("Incoming Games Directory"));
                    directory.mkdirs();
                    File gamefile = new File(directory, filename);
                    if (contents instanceof String) {
                        fout = new PrintWriter(new BufferedWriter(new FileWriter(gamefile)));
                        ((PrintWriter)fout).print((String)contents);
                        ((PrintWriter)fout).close();
                    } else if (contents instanceof InputStream) {
                        fout = new FileOutputStream(gamefile);
                        InputStream is = (InputStream)contents;
                        byte[] buffer = new byte[1024];
                        int n = 0;
                        while ((n = is.read(buffer)) > 0) {
                            ((FileOutputStream)fout).write(buffer, 0, n);
                        }
                        ((FileOutputStream)fout).close();
                    }
                    if (!found) {
                        message = "Games fetched from the MailBox:" + sep;
                        message = message + indent + filename;
                        found = true;
                        continue;
                    }
                    message = message + sep;
                    message = message + indent + filename;
                }
                catch (Exception e) {
                    System.out.println("Failed to save message");
                    e.printStackTrace();
                    saved = false;
                }
            }
            if (!saved || !delete) continue;
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
        folder.close(true);
        store.close();
        return message;
    }

    public static boolean processContent(Object o, HashMap games) throws Exception {
        Multipart mp;
        int count;
        int i;
        boolean processed = false;
        if (o instanceof MimeBodyPart) {
            Object co;
            MimeBodyPart mbp = (MimeBodyPart)o;
            if (!mbp.isMimeType("text/xml") && !mbp.isMimeType("application/octet-stream")) {
                return processed;
            }
            if (mbp.getHeader("FTJava-PBEM", ":") == null) {
                return processed;
            }
            String disp = mbp.getDisposition();
            String filename = mbp.getFileName();
            if (disp == null || filename == null) {
                return processed;
            }
            if (filename.indexOf("Game") != 0) {
                return processed;
            }
            if (disp.equalsIgnoreCase("attachment") && ((co = mbp.getContent()) instanceof String || co instanceof InputStream)) {
                StringTokenizer st = new StringTokenizer(filename, "_", false);
                if (!st.hasMoreTokens()) {
                    return processed;
                }
                games.put(filename, co);
            }
            processed = true;
            return processed;
        }
        if (o instanceof Multipart && (i = 0) < (count = (mp = (Multipart)o).getCount())) {
            return FetchClientEmail.processContent(mp.getBodyPart(i), games);
        }
        return false;
    }
}

