/*
 * Decompiled with CFR 0.152.
 */
package ftjava.mailman;

import ftjava.util.UserPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailToServer {
    public static void sendMail(String subject, String orders, String header) throws MessagingException {
        String to = UserPreferences.getPreferences().getProperty("FTJava Email Address");
        MailToServer.sendMail(to, subject, orders, header, false);
    }

    public static void sendMail(String to, String subject, String orders, String header, boolean fromServer) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", UserPreferences.getPreferences().getProperty("SMTP Host"));
        props.setProperty("mail.user", UserPreferences.getPreferences().getProperty("Mail Username"));
        props.setProperty("mail.smtp.auth", UserPreferences.getPreferences().getProperty("SMTP Authentication"));
        if (fromServer) {
            props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("FTJava Email Address"));
        } else {
            props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("Email Address"));
        }
        props.setProperty("mail.transport.protocol", "smtp");
        MailToServer.sendMail(to, subject, orders, header, props);
    }

    public static void sendMail(String to, String subject, String orders, String header, Properties props) throws MessagingException {
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setContent((Object)orders, "text/xml");
        mbp1.setFileName(subject);
        mbp1.setDisposition("attachment");
        mbp1.addHeader("FTJava-PBEM", header);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        msg.setContent((Multipart)mp);
        msg.setSentDate(new Date());
        if (MailToServer.isSMTPAuthentication()) {
            Transport tr = session.getTransport("smtp");
            tr.connect(UserPreferences.getPreferences().getProperty("SMTP Host"), UserPreferences.getPreferences().getProperty("Mail Username"), UserPreferences.getPreferences().getProperty("Mail Password"));
            msg.saveChanges();
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            tr.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    public static void sendSimpleMail(String to, String subject, String content, String header) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", UserPreferences.getPreferences().getProperty("SMTP Host"));
        props.setProperty("mail.user", "FTJava Game Master");
        props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("FTJava Email Address"));
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", UserPreferences.getPreferences().getProperty("SMTP Authentication"));
        MailToServer.sendSimpleMail(to, subject, content, header, props);
    }

    public static void sendSimpleMail(String to, String subject, String content, String header, Properties props) throws MessagingException {
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        msg.setContent((Object)content, "text/plain");
        msg.setSentDate(new Date());
        if (MailToServer.isSMTPAuthentication()) {
            Transport tr = session.getTransport("smtp");
            tr.connect(UserPreferences.getPreferences().getProperty("SMTP Host"), UserPreferences.getPreferences().getProperty("Mail Username"), UserPreferences.getPreferences().getProperty("Mail Password"));
            msg.saveChanges();
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            tr.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    public static void sendMultipleMail(String[] to, String replyTo, String subject, String content, String header) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", UserPreferences.getPreferences().getProperty("SMTP Host"));
        props.setProperty("mail.user", "FTJava Game Master");
        props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("FTJava Email Address"));
        props.setProperty("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[to.length];
        InternetAddress[] replyAddress = new InternetAddress[1];
        for (int i = 0; i < to.length; ++i) {
            address[i] = new InternetAddress(to[i]);
        }
        replyAddress[0] = new InternetAddress(replyTo);
        msg.setRecipients(Message.RecipientType.BCC, (Address[])address);
        msg.setReplyTo((Address[])replyAddress);
        msg.setSubject(subject);
        msg.setContent((Object)content, "text/plain");
        msg.setSentDate(new Date());
        if (MailToServer.isSMTPAuthentication()) {
            Transport tr = session.getTransport("smtp");
            tr.connect(UserPreferences.getPreferences().getProperty("SMTP Host"), UserPreferences.getPreferences().getProperty("Mail Username"), UserPreferences.getPreferences().getProperty("Mail Password"));
            msg.saveChanges();
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            tr.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    public static String sendGamesToServer() {
        File dir = new File(UserPreferences.getPreferences().getProperty("Outgoing Games Directory"));
        File sentGamesDirectory = new File(dir, "SentGames");
        String message = "No game files sent to the Server.";
        String sep = System.getProperty("line.separator");
        String indent = "      ";
        boolean found = false;
        dir.mkdirs();
        sentGamesDirectory.mkdirs();
        File[] games = dir.listFiles();
        String emailAddress = UserPreferences.getPreferences().getProperty("FTJava Email Address");
        for (int i = 0; i < games.length; ++i) {
            if (!games[i].isFile()) continue;
            StringBuffer buffer = new StringBuffer();
            try {
                String s;
                BufferedReader fis = new BufferedReader(new FileReader(games[i]));
                while ((s = fis.readLine()) != null) {
                    buffer.append(s + "\n");
                }
                fis.close();
            }
            catch (IOException e) {
                message = "Error reading " + games[i].getName() + " for mailing.";
                e.printStackTrace();
                return message;
            }
            try {
                if (!found) {
                    message = "Game files sent to the FTJava server " + emailAddress;
                    found = true;
                }
                boolean fromServer = false;
                MailToServer.sendMail(emailAddress, games[i].getName(), buffer.toString(), "Server Game Turn", fromServer);
                message = message + sep + indent + games[i].getName();
                File sentFile = new File(sentGamesDirectory, games[i].getName());
                if (sentFile.exists()) {
                    sentFile.delete();
                }
                games[i].renameTo(sentFile);
                continue;
            }
            catch (Exception e) {
                message = message + sep + indent + "Email error sending " + games[i].getName();
                System.err.println("Failure to send e-mail!");
            }
        }
        return message;
    }

    public static String sendGameToServer(File theOrders) {
        File dir = new File(UserPreferences.getPreferences().getProperty("Outgoing Games Directory"));
        File sentGamesDirectory = new File(dir, "SentGames");
        String message = "No game file sent to the Server.";
        String sep = System.getProperty("line.separator");
        String indent = "      ";
        boolean found = false;
        dir.mkdirs();
        sentGamesDirectory.mkdirs();
        String emailAddress = UserPreferences.getPreferences().getProperty("FTJava Email Address");
        if (theOrders == null || !theOrders.isFile()) {
            return message;
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String s;
            BufferedReader fis = new BufferedReader(new FileReader(theOrders));
            while ((s = fis.readLine()) != null) {
                buffer.append(s + "\n");
            }
            fis.close();
        }
        catch (IOException e) {
            message = "Error reading " + theOrders.getName() + " for mailing.";
            e.printStackTrace();
            return message;
        }
        try {
            if (!found) {
                message = "Game file sent to the FTJava server " + emailAddress;
                found = true;
            }
            boolean fromServer = false;
            MailToServer.sendMail(emailAddress, theOrders.getName(), buffer.toString(), "Server Game Turn", fromServer);
            message = message + sep + indent + theOrders.getName();
            File sentFile = new File(sentGamesDirectory, theOrders.getName());
            if (sentFile.exists()) {
                sentFile.delete();
            }
            theOrders.renameTo(sentFile);
        }
        catch (Exception e) {
            message = message + sep + indent + "Email error sending " + theOrders.getName();
            System.err.println("Failure to send e-mail!");
        }
        return message;
    }

    public static void sendZipFile(String to, String subject, String zipFile, String header) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", UserPreferences.getPreferences().getProperty("SMTP Host"));
        props.setProperty("mail.user", "FTJava Game Master");
        props.setProperty("mail.from", UserPreferences.getPreferences().getProperty("FTJava Email Address"));
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.auth", UserPreferences.getPreferences().getProperty("SMTP Authentication"));
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        MimeBodyPart mbp1 = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(zipFile);
        mbp1.setDataHandler(new DataHandler((DataSource)fds));
        mbp1.setFileName(fds.getName());
        mbp1.setDisposition("attachment");
        mbp1.addHeader("FTJava-PBEM", header);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        msg.setContent((Multipart)mp);
        msg.setSentDate(new Date());
        if (MailToServer.isSMTPAuthentication()) {
            Transport tr = session.getTransport("smtp");
            tr.connect(UserPreferences.getPreferences().getProperty("SMTP Host"), UserPreferences.getPreferences().getProperty("Mail Username"), UserPreferences.getPreferences().getProperty("Mail Password"));
            msg.saveChanges();
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            tr.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    private static boolean isSMTPAuthentication() {
        String test = UserPreferences.getPreferences().getProperty("SMTP Authentication");
        return test.equals("true");
    }
}

