/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.ai.AIDelegator;
import ftjava.std.GameEngine;
import ftjava.std.GameUtilities;
import ftjava.std.Player;
import ftjava.std.importer.ImportGameEngine;
import ftjava.std.importer.ImportOrders;
import ftjava.util.PlayerContainer;
import ftjava.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class ProcessGame {
    public static void process(File pathName) {
        ProcessGame.process(pathName, false, true);
    }

    public static void process(File pathName, boolean forceProcess) {
        ProcessGame.process(pathName, forceProcess, true);
    }

    public static void process(File pathName, boolean forceProcess, boolean sendMail) {
        String canonicalPath = null;
        String gameName = null;
        boolean combat = false;
        boolean combatTurn = false;
        boolean initialScenario = false;
        String sep = System.getProperty("line.separator");
        System.out.println(sep + "=== FTJava Game Processor ===");
        Date cTime = new Date();
        long sTime = cTime.getTime();
        try {
            canonicalPath = pathName.getCanonicalPath();
            gameName = ProcessGame.getGameName(canonicalPath);
        }
        catch (Exception e) {
            System.err.println("Unable to obtain the canonical path! " + e);
            return;
        }
        if (gameName == null) {
            System.out.println("No game file found in this directory!");
            return;
        }
        String[] fileNames = pathName.list();
        int turnNumber = ProcessGame.getGameTurn(fileNames);
        if (turnNumber < 0) {
            initialScenario = true;
        }
        System.out.println("Game:       " + gameName);
        if (initialScenario) {
            System.out.println("Initial scenario processing");
        } else {
            System.out.println("Turn:       " + turnNumber);
        }
        String gameFile = ProcessGame.getLatestGameFile(gameName, turnNumber, fileNames);
        if (gameFile.indexOf("Combat") != -1) {
            combat = true;
        }
        GameEngine game = null;
        ImportGameEngine ige = new ImportGameEngine();
        try {
            game = ige.readGameEngine(new File(canonicalPath, gameFile));
        }
        catch (Exception e) {
            System.out.println("Failed to read: " + gameFile + sep + e);
            e.printStackTrace();
            return;
        }
        if (initialScenario) {
            combatTurn = true;
            game.setCombatPhase(false);
            if (sendMail) {
                game.sendAllFiles(combatTurn, canonicalPath);
            } else {
                game.writeAllFiles(combatTurn, canonicalPath);
            }
            System.out.println(sep + "Initial game files written.");
            cTime = new Date();
            long eTime = cTime.getTime();
            long deltaTime = eTime - sTime;
            System.out.println("=== End:   " + deltaTime + " ms" + sep);
            return;
        }
        ArrayList playerList = game.getPlayers();
        ArrayList<PlayerContainer> searchList = new ArrayList<PlayerContainer>();
        for (int i = 0; i < playerList.size(); ++i) {
            PlayerContainer pc = new PlayerContainer();
            Player p = (Player)playerList.get(i);
            pc.setId(p.getId());
            pc.setDead(p.isPlayerDead());
            pc.setRobot(p.isPlayerRobot());
            String oName = gameName + "_" + "Turn";
            String altName = gameName + "_" + "T";
            if (combat) {
                oName = oName + StringUtils.turnNumber(turnNumber) + "_";
                oName = oName + "Player" + pc.getId() + "_C_";
                oName = oName + "CombatOrders.xml";
                altName = altName + StringUtils.turnNumber(turnNumber) + "_";
                altName = altName + "P" + pc.getId() + "_C_";
                altName = altName + "COrders.xml";
            } else {
                oName = oName + StringUtils.turnNumber(turnNumber + 1) + "_";
                oName = oName + "Player" + pc.getId() + "_A_";
                oName = oName + "MovementOrders.xml";
                altName = altName + StringUtils.turnNumber(turnNumber + 1) + "_";
                altName = altName + "P" + pc.getId() + "_A_";
                altName = altName + "MOrders.xml";
            }
            pc.setOrdersName(oName);
            pc.setAlternateOrdersName(altName);
            searchList.add(pc);
        }
        ProcessGame.searchFiles(searchList, fileNames);
        boolean runTurn = true;
        boolean deadPlayers = false;
        for (int i = 0; i < searchList.size(); ++i) {
            boolean livePlayer;
            PlayerContainer pc = (PlayerContainer)searchList.get(i);
            System.out.print("Player " + pc.getId() + ":   ");
            System.out.print(pc.getAlternateOrdersName());
            boolean bl = livePlayer = !pc.getDead() && !pc.getRobot();
            if (livePlayer) {
                if (pc.getFound()) {
                    System.out.println("  File found");
                    continue;
                }
                runTurn = false;
                System.out.println("  File not found");
                continue;
            }
            System.out.print("  File not required ");
            if (pc.getDead()) {
                System.out.println("- eliminated");
            } else {
                System.out.println("- bot");
            }
            deadPlayers = true;
        }
        if (!forceProcess && !runTurn) {
            System.out.println(sep + "Unable to run the game turn.");
            cTime = new Date();
            long eTime = cTime.getTime();
            long deltaTime = eTime - sTime;
            System.out.println("=== End:   " + deltaTime + " ms" + sep);
            return;
        }
        if (forceProcess) {
            System.out.println(sep + "Run the game turn! - Forced process");
        } else {
            System.out.println(sep + "Run the game turn!");
        }
        combatTurn = game.isCombatPhase();
        if (!combatTurn) {
            game.initializeMovementOrders();
        }
        ImportOrders io = new ImportOrders();
        for (int i = 0; i < searchList.size(); ++i) {
            PlayerContainer pc = (PlayerContainer)searchList.get(i);
            if (pc.isDead() || pc.isRobot()) continue;
            try {
                File f = pc.useAlternate() ? new File(canonicalPath, pc.getAlternateOrdersName()) : new File(canonicalPath, pc.getOrdersName());
                io.readOrders(game, new FileInputStream(f));
                continue;
            }
            catch (Exception e) {
                if (forceProcess && !deadPlayers) continue;
                System.err.println("Failed to read: " + gameFile + sep + e);
                e.printStackTrace();
            }
        }
        ProcessGame.processOrders(game, combatTurn, false);
        if (!combatTurn && GameUtilities.skipCombatPhase(game)) {
            System.out.println(sep + "Skipping combat phase");
            combatTurn = !combatTurn;
            ProcessGame.processOrders(game, combatTurn, true);
        }
        if (sendMail) {
            game.sendAllFiles(combatTurn, canonicalPath);
        } else {
            game.writeAllFiles(combatTurn, canonicalPath);
        }
        System.out.println("Processing complete." + sep);
        cTime = new Date();
        long eTime = cTime.getTime();
        long deltaTime = eTime - sTime;
        System.out.println("=== End:   " + deltaTime + " ms");
        System.out.println();
    }

    public static void processOrders(GameEngine game, boolean combatTurn, boolean skippedCombat) {
        AIDelegator aiDelegator = new AIDelegator(game);
        if (!combatTurn) {
            game.incrementGameTurn();
            game.resetNotes();
            game.resetWeapons();
            game.rechargeFTLDrives();
            game.transferMessages();
            aiDelegator.movementPhase();
            game.movementPhase();
            game.resolveExtent();
            game.resolveMissileSalvoTargeting();
            game.resolveDamageControl();
            game.setCombatPhase(true);
        } else {
            game.resetDeadWeapons();
            game.evaluateFireControlTargets();
            if (!skippedCombat) {
                game.transferMessages();
            }
            aiDelegator.combatPhase();
            game.resolveMissileSalvoLockOn();
            game.resolvePointDefense();
            game.resolveFighterDamage(false);
            game.resolveFighterAttacks();
            game.resolveExplosiveWeapons();
            game.resolveSalvoMissiles();
            game.makeThresholdChecks();
            game.cleanUp();
            game.resolveShipAttacks();
            game.resolveCoreSystems();
            game.makeThresholdChecks();
            game.resolveFighterDamage(true);
            game.cleanUp();
            game.setCombatPhase(false);
        }
    }

    public static String[] getFileNames(String path) {
        File pathName = new File(path);
        return pathName.list();
    }

    public static String getGameName(String path) {
        String found = null;
        StringTokenizer st = new StringTokenizer(path, File.separator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.indexOf("Games") > -1 || s.indexOf("Game") == -1) continue;
            found = s;
        }
        return found;
    }

    public static int getGameTurn(String[] fileNames) {
        int turn = -1;
        for (int i = 0; i < fileNames.length; ++i) {
            if (fileNames[i].indexOf("Game") == -1 || fileNames[i].indexOf("Turn") == -1 || fileNames[i].indexOf("xml") == -1 || fileNames[i].indexOf("Player") > -1) continue;
            String name = new String(fileNames[i]);
            int index = name.lastIndexOf(".xml");
            name = name.substring(0, index);
            StringTokenizer st = new StringTokenizer(name, "_");
            while (st.hasMoreTokens() && (name = st.nextToken()).indexOf("Turn") == -1) {
            }
            index = name.lastIndexOf("Turn");
            int found = Integer.parseInt(name = name.substring(index + 4, name.length()));
            if (found <= turn) continue;
            turn = found;
        }
        return turn;
    }

    public static String getLatestGameFile(String game, int turn, String[] fileNames) {
        if (turn < 0) {
            return game + ".xml";
        }
        String combat = game + "_" + "Turn" + StringUtils.turnNumber(turn) + "_B_Combat.xml";
        String move = game + "_" + "Turn" + StringUtils.turnNumber(turn) + "_D.xml";
        for (int i = 0; i < fileNames.length; ++i) {
            if (fileNames[i].indexOf("Game") == -1 || fileNames[i].indexOf("Turn") == -1 || fileNames[i].indexOf("xml") == -1 || fileNames[i].indexOf("Player") > -1 || fileNames[i].indexOf(move) <= -1) continue;
            return move;
        }
        return combat;
    }

    public static String getLatestOrdersDate(String canonicalPath, int playerId, String[] fileNames) {
        String date = "";
        String cOrdersName = "_P" + playerId + "_C_COrders.xml";
        String mOrdersName = "_P" + playerId + "_A_MOrders.xml";
        long maxTime = -1L;
        long timeMilli = 0L;
        File ordersFile = null;
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].endsWith(cOrdersName) && !fileNames[i].endsWith(mOrdersName) || (timeMilli = (ordersFile = new File(canonicalPath, fileNames[i])).lastModified()) <= maxTime) continue;
            maxTime = timeMilli;
        }
        if (maxTime > -1L) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 3);
            Date d = new Date(maxTime);
            date = df.format(d);
        }
        return date;
    }

    public static void searchFiles(ArrayList list, String[] fileNames) {
        for (int j = 0; j < list.size(); ++j) {
            PlayerContainer pc = (PlayerContainer)list.get(j);
            String name = pc.getOrdersName();
            String altName = pc.getAlternateOrdersName();
            for (int i = 0; i < fileNames.length; ++i) {
                if (fileNames[i].equals(name)) {
                    pc.setFound(true);
                }
                if (!fileNames[i].equals(altName)) continue;
                pc.setFound(true);
                pc.setAlternate();
            }
        }
    }

    public static String waitingOn(File pathName) {
        return ProcessGame.waitingOn(pathName, false);
    }

    public static String waitingOn(File pathName, boolean mailTo) {
        String canonicalPath = null;
        String gameName = null;
        boolean combat = false;
        long timeMilli = 0L;
        int spacing = 30;
        int teamSpacing = 27;
        int eMailSpacing = 36;
        String result = "";
        String header = "";
        String sep = System.getProperty("line.separator");
        try {
            canonicalPath = pathName.getCanonicalPath();
            gameName = ProcessGame.getGameName(canonicalPath);
        }
        catch (Exception e) {
            return "Server error:  Game not found";
        }
        if (gameName == null) {
            return "Server error:  Game not found";
        }
        String[] fileNames = pathName.list();
        int turnNumber = ProcessGame.getGameTurn(fileNames);
        String gameFile = ProcessGame.getLatestGameFile(gameName, turnNumber, fileNames);
        GameEngine game = null;
        File gF = new File(canonicalPath, gameFile);
        timeMilli = gF.lastModified();
        ImportGameEngine ige = new ImportGameEngine();
        try {
            game = ige.readGameEngine(gF);
        }
        catch (Exception e) {
            result = result + "Server Error: Failed to read: " + gameFile;
            e.printStackTrace();
            return result;
        }
        String theScenario = game.getName();
        header = header + sep;
        header = header + "Game Status" + sep + sep;
        header = header + theScenario + sep + sep;
        result = result + gameName + ": ";
        if (turnNumber < 0) {
            header = header + sep + "Initial scenario setup" + sep + sep;
            return header + result;
        }
        if (gameFile.indexOf("Combat") != -1) {
            combat = true;
            result = result + "Turn " + StringUtils.turnNumber(turnNumber) + "  ";
            result = result + "Combat";
        } else {
            result = result + "Turn " + StringUtils.turnNumber(turnNumber + 1) + "  ";
            result = result + "Movement";
        }
        while (result.length() < spacing) {
            result = result + " ";
        }
        Date d = new Date(timeMilli);
        DateFormat df = DateFormat.getDateTimeInstance(2, 3);
        result = result + "Last run: " + df.format(d) + sep + sep;
        ArrayList playerList = game.getPlayers();
        ArrayList<PlayerContainer> searchList = new ArrayList<PlayerContainer>();
        for (int i = 0; i < playerList.size(); ++i) {
            PlayerContainer pc = new PlayerContainer();
            Player p = (Player)playerList.get(i);
            pc.setId(p.getId());
            pc.setName(p.getName());
            pc.setEmail(p.getEmail());
            pc.setTeam(p.getTeam());
            pc.setDead(p.isPlayerDead());
            String oName = gameName + "_" + "Turn";
            String aName = gameName + "_" + "T";
            if (combat) {
                oName = oName + StringUtils.turnNumber(turnNumber) + "_";
                oName = oName + "Player" + pc.getId() + "_C_";
                oName = oName + "CombatOrders.xml";
                aName = aName + StringUtils.turnNumber(turnNumber) + "_";
                aName = aName + "P" + pc.getId() + "_C_";
                aName = aName + "COrders.xml";
            } else {
                int j = turnNumber + 1;
                oName = oName + StringUtils.turnNumber(j) + "_";
                oName = oName + "Player" + pc.getId() + "_A_";
                oName = oName + "MovementOrders.xml";
                aName = aName + StringUtils.turnNumber(j) + "_";
                aName = aName + "P" + pc.getId() + "_A_";
                aName = aName + "MOrders.xml";
            }
            pc.setOrdersName(oName);
            pc.setAlternateOrdersName(aName);
            searchList.add(pc);
        }
        ProcessGame.searchFiles(searchList, fileNames);
        String received = "Orders received from: " + sep;
        String waiting = "Waiting for orders from: " + sep;
        String dead = "Orders not required from: " + sep;
        int countDead = 0;
        int countWaiting = 0;
        for (int i = 0; i < searchList.size(); ++i) {
            PlayerContainer pc = (PlayerContainer)searchList.get(i);
            StringBuffer line = new StringBuffer();
            line.append("  " + pc.getName());
            while (line.length() < spacing) {
                line.append(" ");
            }
            line.append(pc.getTeam());
            while (line.length() < spacing + teamSpacing) {
                line.append(" ");
            }
            line.append("(" + pc.getEmail() + ")");
            while (line.length() < spacing + teamSpacing + eMailSpacing) {
                line.append(" ");
            }
            String theDate = ProcessGame.getLatestOrdersDate(canonicalPath, pc.getId(), fileNames);
            line.append(theDate);
            line.append(sep);
            if (!pc.getDead()) {
                if (pc.getFound()) {
                    received = received + line.toString();
                    continue;
                }
                waiting = waiting + line.toString();
                ++countWaiting;
                continue;
            }
            dead = dead + line.toString();
            ++countDead;
        }
        result = countWaiting == 0 ? result + "All orders received." + sep : (countDead == 0 ? result + received + waiting : result + received + waiting + dead);
        return header + result;
    }

    public static ArrayList getPlayers(File pathName) {
        String canonicalPath = null;
        String gameName = null;
        try {
            canonicalPath = pathName.getCanonicalPath();
            gameName = ProcessGame.getGameName(canonicalPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (gameName == null) {
            return null;
        }
        String[] fileNames = pathName.list();
        int turnNumber = ProcessGame.getGameTurn(fileNames);
        String gameFile = ProcessGame.getLatestGameFile(gameName, turnNumber, fileNames);
        GameEngine game = null;
        File gF = new File(canonicalPath, gameFile);
        ImportGameEngine ige = new ImportGameEngine();
        try {
            game = ige.readGameEngine(gF);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return game.getPlayers();
    }
}

