/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.util.XMLUtilities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Armor {
    private ArrayList armorShells = new ArrayList();

    public Armor() {
        this(0);
    }

    public Armor(int a) {
        this.setTotalArmor(a);
    }

    public int getArmorShellCount() {
        return this.armorShells.size();
    }

    public void setArmor(int a) {
        this.setTotalArmor(a);
    }

    public void setTotalArmor(int a) {
        this.setTotalArmor(a, 0);
    }

    public void setTotalArmor(int a, int lvl) {
        if (lvl < 0 || lvl > this.armorShells.size()) {
            throw new IllegalArgumentException("Illegal armor level!");
        }
        if (lvl == this.armorShells.size()) {
            ArmorShell s = new ArmorShell(a);
            this.armorShells.add(s);
        } else {
            ArmorShell s = (ArmorShell)this.armorShells.get(lvl);
            s.setTotalArmor(a);
        }
    }

    public int getTotalArmor() {
        int total = 0;
        for (int i = 0; i < this.armorShells.size(); ++i) {
            total += this.getTotalArmor(i);
        }
        return total;
    }

    public int getTotalArmor(int lvl) {
        ArmorShell s = (ArmorShell)this.armorShells.get(lvl);
        return s.getTotalArmor();
    }

    public int getRemainingArmor() {
        int remaining = 0;
        for (int i = 0; i < this.armorShells.size(); ++i) {
            remaining += this.getRemainingArmor(i);
        }
        return remaining;
    }

    public int getRemainingArmor(int lvl) {
        ArmorShell s = (ArmorShell)this.armorShells.get(lvl);
        return s.getRemainingArmor();
    }

    public void setRemainingArmor(int a) {
        this.setRemainingArmor(a, 0);
    }

    public void setRemainingArmor(int a, int lvl) {
        ArmorShell s = (ArmorShell)this.armorShells.get(lvl);
        s.setRemainingArmor(a);
    }

    public void setValue(String Name, String Value) {
        int i;
        StringTokenizer st;
        if (Name.equals("totalArmor")) {
            st = new StringTokenizer(Value, ",");
            i = 0;
            while (st.hasMoreTokens()) {
                this.setTotalArmor(Integer.parseInt(st.nextToken()), i);
                ++i;
            }
        }
        if (Name.equals("remainingArmor")) {
            st = new StringTokenizer(Value, ",");
            i = 0;
            while (st.hasMoreTokens()) {
                this.setRemainingArmor(Integer.parseInt(st.nextToken()), i);
                ++i;
            }
        }
    }

    public int[] takeDamage(int[] damage) {
        int i = 0;
        if (damage.length <= this.armorShells.size()) {
            int[] temp = new int[this.armorShells.size() + 1];
            System.arraycopy(damage, 0, temp, 0, damage.length);
            damage = temp;
        }
        int j = 0;
        for (i = this.armorShells.size() - 1; i >= 0; --i) {
            ArmorShell s = (ArmorShell)this.armorShells.get(i);
            if (damage[j] < 0) {
                throw new IllegalArgumentException("Damage must be positive!");
            }
            if (s.getRemainingArmor() >= damage[j]) {
                s.setRemainingArmor(s.getRemainingArmor() - damage[j]);
                damage[j] = 0;
            } else {
                int n = j + 1;
                damage[n] = damage[n] + (damage[j] - s.getRemainingArmor());
                damage[j] = 0;
                s.setRemainingArmor(0);
            }
            ++j;
        }
        return damage;
    }

    public int computeMass() {
        int totalArmor = 0;
        for (int i = 0; i < this.armorShells.size(); ++i) {
            ArmorShell s = (ArmorShell)this.armorShells.get(i);
            totalArmor += s.getTotalArmor();
        }
        return totalArmor;
    }

    public int computePointCost() {
        int totalCost = 0;
        int costPerMass = 2;
        for (int i = 0; i < this.armorShells.size(); ++i) {
            ArmorShell s = (ArmorShell)this.armorShells.get(i);
            totalCost += costPerMass * s.getTotalArmor();
            costPerMass += 2;
        }
        return totalCost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("   Armor: ");
        int numShells = this.armorShells.size();
        boolean first = true;
        for (int j = numShells - 1; j >= 0; --j) {
            ArmorShell s = (ArmorShell)this.armorShells.get(j);
            int totalArmor = s.getTotalArmor();
            int remainingArmor = s.getRemainingArmor();
            if (first) {
                first = false;
            } else {
                sb.append("          ");
            }
            for (int i = 0; i < totalArmor; ++i) {
                if (totalArmor - i <= remainingArmor) {
                    sb.append("O");
                    continue;
                }
                sb.append("-");
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        ArmorShell sh;
        int i;
        String s = "";
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 8) {
            return s;
        }
        sb.append(t);
        sb.append("<Armor totalArmor=\"");
        for (i = 0; i < this.armorShells.size(); ++i) {
            sh = (ArmorShell)this.armorShells.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(sh.getTotalArmor());
        }
        sb.append("\"");
        if (level >= 1) {
            sb.append(" remainingArmor=\"");
            for (i = 0; i < this.armorShells.size(); ++i) {
                sh = (ArmorShell)this.armorShells.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(sh.getRemainingArmor());
            }
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    public static class ArmorShell {
        private int totalArmor;
        private int remainingArmor;
        private boolean remainingArmorIsImplicit;

        public ArmorShell(int total) {
            this(total, total);
            this.remainingArmorIsImplicit = true;
        }

        public ArmorShell(int total, int remaining) {
            this.setTotalArmor(total);
            this.setRemainingArmor(remaining);
        }

        public int getTotalArmor() {
            return this.totalArmor;
        }

        public void setTotalArmor(int total) {
            this.totalArmor = total < 0 ? 0 : total;
            if (this.remainingArmorIsImplicit) {
                this.setRemainingArmor(this.totalArmor);
                this.remainingArmorIsImplicit = true;
            } else if (this.remainingArmor > this.totalArmor) {
                this.remainingArmor = this.totalArmor;
            }
        }

        public int getRemainingArmor() {
            return this.remainingArmor;
        }

        public void setRemainingArmor(int remaining) {
            this.remainingArmor = remaining > this.totalArmor ? this.totalArmor : (remaining < 0 ? 0 : remaining);
            this.remainingArmorIsImplicit = false;
        }

        public int takeDamage(int damage) {
            if (damage == 0) {
                return 0;
            }
            if (this.remainingArmor >= damage) {
                this.remainingArmor -= damage;
                return 0;
            }
            int pass = damage - this.remainingArmor;
            this.remainingArmor = 0;
            return pass;
        }
    }
}

