/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class BeamBattery
extends Weapon {
    protected int rating;

    public BeamBattery() {
        this(1, Weapon.ALL_ARCS);
    }

    public BeamBattery(int beamClass) {
        this(beamClass, Weapon.ALL_ARCS);
    }

    public BeamBattery(int beamClass, int arcCoverage) {
        this.rating = beamClass;
        if (!this.getOptions().getAftArcFire() && arcCoverage == Weapon.AFT_ARC) {
            arcCoverage = Weapon.FORE_ARC;
        }
        this.setArcs(arcCoverage);
        this.setSystemName("Class " + this.rating + " Beam Battery " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange((double)this.rating * this.getOptions().getBeamRangeBand());
    }

    public BeamBattery(int beamClass, String arcString) {
        this.rating = beamClass;
        this.setArcs(Weapon.parseArcString(arcString));
        this.setSystemName("Class " + this.rating + " Beam Battery " + this.getArcsString());
        this.setMaximumRange((double)this.rating * this.getOptions().getBeamRangeBand());
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int theRating) {
        this.rating = theRating;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("rating")) {
            this.setRating(Integer.parseInt(Value));
            this.setMaximumRange((double)this.rating * this.getOptions().getBeamRangeBand());
            handled = true;
            this.setSystemName("Class " + this.rating + " Beam Battery " + this.getArcsString());
        }
        if (Name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        boolean pdsMode = false;
        if (this.rating == 1 && (target instanceof MissileSalvo || target instanceof FighterGroup)) {
            pdsMode = true;
        }
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!pdsMode && !(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        if (pdsMode) {
            this.fireAtPointDefense(firer, target);
        } else {
            this.fireAtDirectFire(firer, target);
        }
    }

    private void fireAtDirectFire(SpaceObject firer, SpaceObject target) {
        String record;
        Ship s;
        int[] damage = new int[1];
        DecimalFormat df = new DecimalFormat("0.0");
        int rerolls = 0;
        int penetration = 0;
        int screens = 0;
        double rangeBand = this.getOptions().getBeamRangeBand();
        if (target instanceof Ship) {
            s = (Ship)target;
            screens = s.getNumberOfActiveScreens();
        }
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        int dice = this.rating;
        for (int i = 1; i < this.rating; ++i) {
            if (!(range > (double)i * rangeBand)) continue;
            --dice;
        }
        if (firer.rangeTo(target) > this.getMaximumRange()) {
            return;
        }
        if (range > this.getMaximumRange()) {
            dice = 0;
        }
        String targetName = target.getName();
        this.setFired();
        boolean hit = false;
        boolean deflected = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        while (dice > 0) {
            block8: for (int i = 0; i < dice; ++i) {
                int die = Dice.rollD6(firer.getCrewQuality());
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        continue block8;
                    }
                    case 4: {
                        if (screens == 0) {
                            int n = penetration;
                            damage[n] = damage[n] + 1;
                            hit = true;
                            continue block8;
                        }
                        deflected = true;
                        continue block8;
                    }
                    case 5: {
                        int n = penetration;
                        damage[n] = damage[n] + 1;
                        hit = true;
                        continue block8;
                    }
                    case 6: {
                        if (screens == 2) {
                            int n = penetration;
                            damage[n] = damage[n] + 1;
                        } else {
                            int n = penetration;
                            damage[n] = damage[n] + 2;
                        }
                        hit = true;
                        ++rerolls;
                        continue block8;
                    }
                }
            }
            if (rerolls > 0 && this.getOptions().getPenetratingDamage()) {
                dice = rerolls;
                rerolls = 0;
                screens = 0;
                int[] temp = new int[++penetration + 1];
                System.arraycopy(damage, 0, temp, 0, damage.length);
                damage = temp;
                continue;
            }
            dice = 0;
        }
        if (!hit) {
            String record2;
            if (deflected) {
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Deflected by " + targetName + "'s shielding. " + playTestResults);
                    record2 = firer.getName() + " hit, but deflected with a class " + this.getRating() + " beam battery. " + playTestResults;
                } else {
                    this.setNotes("Deflected by " + targetName + "'s shielding.");
                    record2 = firer.getName() + " hit, but deflected with a class " + this.getRating() + " beam battery.";
                }
            } else if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a class " + this.getRating() + " beam battery. " + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a class " + this.getRating() + " beam battery.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        int totalDamage = 0;
        for (int i = 0; i < damage.length; ++i) {
            totalDamage += damage[i];
        }
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(damage[0]) + " armor and " + StringUtils.number(totalDamage - damage[0]) + " hull points. " + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " beam battery. " + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " beam battery.";
        }
        target.addLog("Attack", "High", record);
        if (totalDamage >= 3 * this.rating) {
            GameEngine ge = firer.getGameEngine();
            record = firer.getName() + " hit " + target.getName() + " for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " beam battery.";
            ge.addTurnReport("Attack", "High", record);
        }
        s = (Ship)target;
        s.takeDamage(damage);
    }

    private void fireAtPointDefense(SpaceObject firer, SpaceObject target) {
        DecimalFormat df = new DecimalFormat("0.0");
        int[] damage = new int[1];
        int rerolls = 0;
        int dice = 1;
        int totalDamage = 0;
        double rangeBand = this.getOptions().getPointDefenseRange();
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        dice = this.rating;
        this.setFired();
        boolean hit = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        if (range < rangeBand) {
            while (dice > 0) {
                block6: for (int i = 0; i < dice; ++i) {
                    int die = Dice.rollD6(firer.getCrewQuality());
                    playTestResults = playTestResults + "(" + die + ") ";
                    switch (die) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            continue block6;
                        }
                        case 5: {
                            ++totalDamage;
                            damage[0] = damage[0] + 1;
                            hit = true;
                            continue block6;
                        }
                        case 6: {
                            ++totalDamage;
                            damage[0] = damage[0] + 1;
                            hit = true;
                            ++rerolls;
                            continue block6;
                        }
                    }
                }
                if (rerolls > 0 && this.getOptions().getPenetratingDamage()) {
                    dice = rerolls;
                    rerolls = 0;
                    continue;
                }
                dice = 0;
            }
        }
        String targetName = target.getName();
        if (!hit) {
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed " + targetName + ". " + playTestResults);
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed with " + "a Class 1 beam battery. " + playTestResults);
                }
            } else {
                this.setNotes("Missed " + targetName + ".");
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed with " + "a Class 1 beam battery.");
                }
            }
            return;
        }
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(totalDamage) + playTestResults);
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(totalDamage) + " with a Class 1 beam battery. " + playTestResults);
            }
        } else {
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(totalDamage) + ".");
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(totalDamage) + " with a Class 1 beam battery. ");
            }
        }
        if (target instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)target;
            ms.takeDamage(damage);
        }
        if (target instanceof FighterGroup) {
            FighterGroup fg = (FighterGroup)target;
            fg.takeDamage(damage);
        }
    }

    public int computeMass() {
        if (this.rating == 1) {
            return 1;
        }
        int count = this.computeNumberOfArcs();
        if (this.rating == 2 && count <= 3) {
            return 2;
        }
        if (this.rating == 2) {
            return 3;
        }
        return (int)Math.pow(2.0, this.rating - 1) + (this.rating - 2) * (count - 1);
    }

    public int computePointCost() {
        return 3 * this.computeMass();
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t);
        sb.append(t);
        sb.append("<BeamBattery ");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" rating=\"");
        sb.append(this.rating);
        sb.append("\" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (this.rating == 1 && this.getTargetId() != 0 && (level == 2 || level == 1)) {
            sb.append(" targetId=\"" + this.getTargetId() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    static {
        Weapon.addSystem("BeamBattery", new BeamBattery());
    }
}

