/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.util.Dice;

public class CorePowerCore
extends ShipSystem {
    public CorePowerCore() {
        this.setSystemName("Power Core");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void takeThresholdCheck(int level) {
        if (this.getSystemStatus().equals("Destroyed")) {
            return;
        }
        if (Dice.rollD6() < level + 1) {
            return;
        }
        if (this.getSystemStatus().equals("Damaged")) {
            this.setDestroyed();
        } else {
            this.setDamaged();
        }
    }

    public int computeMass() {
        return 0;
    }

    public int computePointCost() {
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   ");
        sb.append(this.getSystemName());
        if (!this.getSystemStatus().equals("Operational")) {
            while (sb.length() < this.getOptions().getStatusSpacing()) {
                sb.append(" ");
            }
            sb.append(this.getSystemStatus());
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String result = "";
        StringBuffer sb = new StringBuffer();
        if (level == 0) {
            return result;
        }
        if (level >= 5) {
            return result;
        }
        sb.append("<CorePowerCore id=\"");
        sb.append(this.getId());
        sb.append("\"");
        sb.append(" status=\"");
        sb.append(this.getSystemStatus());
        sb.append("\"");
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }
}

