/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroup;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class FighterBay
extends Weapon {
    private FighterGroup landedGroup;
    private boolean isActive;

    public FighterBay() {
        this.setArcs(0);
        this.setSystemName("Fighter Bay");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
        this.setActive(false);
    }

    public void takeThresholdCheck(int level) {
        super.takeThresholdCheck(level);
        if (this.landedGroup != null && (this.isDamaged() || this.isDestroyed())) {
            this.landedGroup.takeDamage(new int[]{6});
        }
    }

    public FighterGroup getLandedFighterGroup() {
        return this.landedGroup;
    }

    public void setLandedFighterGroup(FighterGroup fg) {
        if (fg != null && this.landedGroup != null) {
            return;
        }
        this.landedGroup = fg;
    }

    public void setActive(boolean tf) {
        this.isActive = tf;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public int computeMass() {
        return 9;
    }

    public int computePointCost() {
        return 27;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<FighterBay");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            sb.append(" recharge=\"" + this.getRecharge() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("FighterBay", new FighterBay());
    }
}

