/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroupType;
import ftjava.std.FighterOrders;
import ftjava.std.LogRecord;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class FighterGroup
extends SpaceObject {
    public static final String NORMAL_QUALITY = "Normal";
    public static final String ACE_QUALITY = "Ace";
    public static final String TURKEY_QUALITY = "Turkey";
    public static final int NO_TARGET = 0;
    public static final int ANY_ENEMY_SHIP = -1;
    public static final int ANY_ENEMY_FIGHTER = -2;
    public static final int ANY_FRIENDLY_SHIP = -3;
    public static final double MAX_RECOVERY_RANGE = 6.0;
    public static final ArrayList orderChoices = new ArrayList();
    public static final int MOVE = 0;
    public static final int STAND_OFF = 1;
    public static final int SCREEN = 2;
    public static final int ATTACK = 3;
    public static final int AGGRESSIVE_ATTACK = 4;
    public static final int CONSERVATIVE_ATTACK = 5;
    public static final int ENGAGE_FIGHTERS = 6;
    public static final int ENGAGE_RANGED_WEAPONS = 7;
    public static final int RETURN_HOME = 8;
    public static final int EMERGENCY_LANDING = 9;
    private String team = "";
    private String race = "";
    private int count = 6;
    private int damageTaken = 0;
    private String fighterClass = "";
    private FighterGroupType fighterType = new FighterGroupType();
    private String pilotQuality = "Normal";
    private SpaceObject target = null;
    private int targetId = 0;
    private int combatEndurance = 6;
    private int moraleFailures;
    private boolean escorting = false;
    private SpaceObject escortedShip = null;
    private int escortedShipId = 0;
    private boolean mayScreenMove = false;
    private boolean onBoard = false;
    private boolean launching = false;
    private int carrierShipId = 0;
    private int fighterBayId = 0;
    private boolean hasAttacked = false;
    private boolean mayUseSecondaryMove = false;
    private boolean dogfighting = false;
    private FighterOrders orders = (FighterOrders)orderChoices.get(0);
    private double moveToX;
    private double moveToY;
    private int moveToHeading;

    public void setName() {
        this.setName("FG " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setRace(String s) {
        this.race = s;
    }

    public String getRace() {
        return this.race;
    }

    public void setFighterClass(String s) {
        this.fighterClass = s;
    }

    public String getFighterClass() {
        return this.fighterClass;
    }

    public void setCount(int c) {
        this.count = c;
    }

    public int getCount() {
        return this.count;
    }

    public void setType(String s) {
        this.fighterType.setType(s);
    }

    public FighterGroupType getType() {
        return this.fighterType;
    }

    public int computePointCost() {
        return this.fighterType.computePointCost();
    }

    public void setPilotQuality(String s) {
        if (s.equals(NORMAL_QUALITY)) {
            this.pilotQuality = s;
        } else if (s.equals(ACE_QUALITY)) {
            this.pilotQuality = s;
        } else if (s.equals(TURKEY_QUALITY)) {
            this.pilotQuality = s;
        }
    }

    public String getPilotQuality() {
        return this.pilotQuality;
    }

    public boolean isAce() {
        return this.pilotQuality.equals(ACE_QUALITY);
    }

    public boolean isTurkey() {
        return this.pilotQuality.equals(TURKEY_QUALITY);
    }

    public boolean isBroken() {
        if (this.isTurkey()) {
            return this.moraleFailures >= 2;
        }
        return this.moraleFailures >= 3;
    }

    public void setOriginalPosition() {
        this.setPastX(this.getXPosition());
        this.setPastY(this.getYPosition());
        this.setPastHeading(this.getHeading());
    }

    public void resetOriginalPosition() {
        this.setPosition(this.getPastX(), this.getPastY());
        this.setHeading(this.getPastHeading());
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
    }

    public SpaceObject getTarget() {
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setCombatEndurance(int t) {
        this.combatEndurance = t;
    }

    public int getCombatEndurance() {
        return this.combatEndurance;
    }

    public void resetCombatEndurance() {
        this.combatEndurance = 6;
        if (this.fighterType.isALongRangeFighter()) {
            this.combatEndurance = 9;
        }
    }

    public void spendEnduranceForTorpedo() {
        this.combatEndurance -= 6;
        if (this.combatEndurance < 0) {
            this.combatEndurance = 0;
        }
    }

    public boolean useCombatEndurance() {
        if (this.combatEndurance <= 0) {
            this.combatEndurance = 0;
            return false;
        }
        --this.combatEndurance;
        return true;
    }

    public int getSpeed() {
        int speed = (int)this.getOptions().getFighterMovementRange();
        if (this.fighterType.isAFastFighter()) {
            speed = (int)this.getOptions().getFighterFastMovementRange();
        }
        return speed;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    public void setHasAttacked(boolean tf) {
        this.hasAttacked = tf;
    }

    public void setEscorting(boolean tf) {
        this.escorting = tf;
    }

    public boolean isEscorting() {
        return this.escorting;
    }

    public void setEscortedShip(SpaceObject t) {
        this.escortedShip = t;
    }

    public SpaceObject getEscortedShip() {
        return this.escortedShip;
    }

    public void setEscortedShipId(int t) {
        this.escortedShipId = t;
    }

    public int getEscortedShipId() {
        return this.escortedShipId;
    }

    public void setMayScreenMove(boolean tf) {
        this.mayScreenMove = tf;
    }

    public boolean mayScreenMove() {
        return this.mayScreenMove;
    }

    public void setOnBoard(boolean tf) {
        this.onBoard = tf;
    }

    public boolean isOnBoard() {
        return this.onBoard;
    }

    public boolean isDead() {
        return this.getCount() <= 0;
    }

    public void setLaunching(boolean tf) {
        this.launching = tf;
    }

    public boolean isLaunching() {
        return this.launching;
    }

    public void setCarrierShipId(int t) {
        this.carrierShipId = t;
    }

    public int getCarrierShipId() {
        return this.carrierShipId;
    }

    public void setFighterBayId(int t) {
        this.fighterBayId = t;
    }

    public int getFighterBayId() {
        return this.fighterBayId;
    }

    public void setMayUseSecondaryMove(boolean tf) {
        this.mayUseSecondaryMove = tf;
    }

    public boolean mayUseSecondaryMove() {
        if (this.combatEndurance <= 0) {
            return false;
        }
        return this.mayUseSecondaryMove;
    }

    public void setDogfighting(boolean tf) {
        this.dogfighting = tf;
    }

    public boolean isDogfighting() {
        return this.dogfighting;
    }

    public FighterOrders getFighterOrders() {
        return this.orders;
    }

    public void setFighterOrders(FighterOrders o) {
        this.orders = o;
    }

    public void setDefaultOrders() {
        this.setMoveToX(this.getXPosition());
        this.setMoveToY(this.getYPosition());
        this.setMoveToHeading(this.getHeading());
        this.mayUseSecondaryMove = false;
    }

    public void setMoveToX(double x) {
        this.moveToX = x;
    }

    public double getMoveToX() {
        return this.moveToX;
    }

    public void setMoveToY(double y) {
        this.moveToY = y;
    }

    public double getMoveToY() {
        return this.moveToY;
    }

    public void setMoveToHeading(int h) {
        this.moveToHeading = h;
    }

    public int getMoveToHeading() {
        return this.moveToHeading;
    }

    public Ship getCarrierShip() {
        return this.getGameEngine().getShipById(this.carrierShipId);
    }

    public Weapon getFighterBay() {
        Ship s = this.getCarrierShip();
        if (s == null) {
            return null;
        }
        return s.getWeaponById(this.fighterBayId);
    }

    public boolean isAStandardFighter() {
        return this.fighterType.isAStandardFighter();
    }

    public boolean isAFastFighter() {
        return this.fighterType.isAFastFighter();
    }

    public boolean isALongRangeFighter() {
        return this.fighterType.isALongRangeFighter();
    }

    public boolean isAHeavyFighter() {
        return this.fighterType.isAHeavyFighter();
    }

    public boolean isAnInterceptor() {
        return this.fighterType.isAnInterceptor();
    }

    public boolean isAnAttackFighter() {
        return this.fighterType.isAnAttackFighter();
    }

    public boolean isATorpedoFighter() {
        return this.fighterType.isATorpedoFighter();
    }

    public boolean isANeedleFighter() {
        return this.fighterType.isANeedleFighter();
    }

    public String getAction() {
        Ship s = null;
        if (this.getCount() == 0) {
            return "Deceased";
        }
        if (this.onBoard) {
            SpaceObject so = this.getGameEngine().getObjectById(this.carrierShipId);
            Ship carrier = (Ship)so;
            if (carrier != null) {
                return "On board " + carrier.getClassAbbrev() + " " + carrier.getName();
            }
            return "On board carrier";
        }
        SpaceObject target = this.getGameEngine().getObjectById(this.targetId);
        if (this.isTargetAFighterGroup()) {
            return "Engaging fighter group " + target.getName();
        }
        if (this.getFighterOrders().toString().equals("Screen")) {
            if (target instanceof Ship) {
                s = (Ship)target;
            }
            if (s == null) {
                return "Screening ";
            }
            return "Screening " + s.getClassAbbrev() + " " + s.getName();
        }
        if (this.getFighterOrders().toString().equals("Attack Target") || this.getFighterOrders().toString().equals("Aggressive Attack") || this.getFighterOrders().toString().equals("Conservative Attack")) {
            if (target instanceof Ship) {
                s = (Ship)target;
            }
            if (s == null) {
                return "Attacking ";
            }
            return "Attacking " + s.getClassAbbrev() + " " + s.getName();
        }
        if (this.getFighterOrders().toString().equals("Engage Ranged Weapons")) {
            return "Engaging ranged weapons";
        }
        if (this.getFighterOrders().toString().equals("Return Home") || this.getFighterOrders().toString().equals("Emergency Landing")) {
            if (target instanceof Ship) {
                s = (Ship)target;
            }
            if (s == null) {
                return "Returning to carrier";
            }
            return "Returning to " + s.getClassAbbrev() + " " + s.getName();
        }
        if (this.launching) {
            SpaceObject so = this.getGameEngine().getObjectById(this.carrierShipId);
            Ship carrier = (Ship)so;
            if (carrier == null) {
                return "Launching from carrier";
            }
            return "Launching from " + carrier.getClassAbbrev() + " " + carrier.getName();
        }
        if (this.targetId == 0) {
            return "In transit";
        }
        return "Loitering";
    }

    public boolean isTargetAShip() {
        if (this.getTargetId() == 0) {
            return false;
        }
        SpaceObject so = this.getGameEngine().getObjectById(this.getTargetId());
        return so instanceof Ship;
    }

    public boolean isTargetAFighterGroup() {
        if (this.getTargetId() == 0) {
            return false;
        }
        SpaceObject so = this.getGameEngine().getObjectById(this.getTargetId());
        return so instanceof FighterGroup;
    }

    public boolean amIBeingAttacked() {
        int myId = this.getId();
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        for (int i = 0; i < allObjs.size(); ++i) {
            FighterGroup efg;
            SpaceObject so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || this.rangeTo(so) > this.getOptions().getFighterRange() || (efg = (FighterGroup)so).getTargetId() != myId) continue;
            return true;
        }
        return false;
    }

    public boolean isMyScreenedShipBeingAttacked() {
        int myShipId = this.getTargetId();
        Ship s = this.getGameEngine().getShipById(myShipId);
        if (s == null) {
            return false;
        }
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        for (int i = 0; i < allObjs.size(); ++i) {
            FighterGroup efg;
            SpaceObject so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || s.rangeTo(so) > this.getOptions().getFighterRange() || (efg = (FighterGroup)so).getTargetId() != myShipId) continue;
            return true;
        }
        return false;
    }

    public ArrayList whoIsAttackingMyScreenedShip() {
        ArrayList<FighterGroup> theList = new ArrayList<FighterGroup>();
        int myShipId = this.getTargetId();
        Ship s = this.getGameEngine().getShipById(myShipId);
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        for (int i = 0; i < allObjs.size(); ++i) {
            FighterGroup efg;
            SpaceObject so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || s.rangeTo(so) > this.getOptions().getFighterRange() || (efg = (FighterGroup)so).getTargetId() != myShipId) continue;
            theList.add(efg);
        }
        return theList;
    }

    public ArrayList whoIsAttackingMe() {
        ArrayList<FighterGroup> theList = new ArrayList<FighterGroup>();
        int myId = this.getId();
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        for (int i = 0; i < allObjs.size(); ++i) {
            FighterGroup efg;
            SpaceObject so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || this.rangeTo(so) > this.getOptions().getFighterRange() || (efg = (FighterGroup)so).getTargetId() != myId) continue;
            theList.add(efg);
        }
        return theList;
    }

    public ArrayList whoIsInMyAttackRange() {
        return this.whoIsInMyAttackRange(this.getOptions().getFighterRange());
    }

    public ArrayList whoIsInMyAttackRange(double theRange) {
        ArrayList<FighterGroup> theList = new ArrayList<FighterGroup>();
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        for (int i = 0; i < allObjs.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || this.rangeTo(so) > theRange) continue;
            FighterGroup efg = (FighterGroup)so;
            theList.add(efg);
        }
        return theList;
    }

    public FighterGroup whoIsThePriorityTarget(ArrayList theList) {
        int i;
        if (theList.size() == 0) {
            return null;
        }
        if (theList.size() == 1) {
            return (FighterGroup)theList.get(0);
        }
        FighterGroup efg = null;
        for (i = 0; i < theList.size(); ++i) {
            efg = (FighterGroup)theList.get(i);
            if (!efg.isATorpedoFighter() || efg.amIBeingAttacked()) continue;
            return efg;
        }
        for (i = 0; i < theList.size(); ++i) {
            efg = (FighterGroup)theList.get(i);
            if (efg.amIBeingAttacked()) continue;
            return efg;
        }
        for (i = 0; i < theList.size(); ++i) {
            efg = (FighterGroup)theList.get(i);
            if (!efg.isATorpedoFighter()) continue;
            return efg;
        }
        return (FighterGroup)theList.get(0);
    }

    public boolean isMyTargetInAttackRange() {
        this.target = this.getGameEngine().getObjectById(this.targetId);
        if (this.targetId == 0 || this.target == null) {
            return false;
        }
        return this.rangeTo(this.target) <= this.getOptions().getFighterRange();
    }

    public void lockOnToTargetShip(boolean secondMovement) {
        if (this.targetId == -1) {
            Ship s = this.getClosestEnemyShip();
            if (s == null) {
                this.setTargetId(0);
                return;
            }
            if (this.rangeTo(s) > this.getOptions().getFighterRange()) {
                if (secondMovement) {
                    this.setTargetId(0);
                }
                return;
            }
            this.setTargetId(s.getId());
            this.setHeading(this.headingTo(s.getXPosition(), s.getYPosition()));
        }
    }

    public void defendIfAttacked() {
        if (!this.amIBeingAttacked()) {
            return;
        }
        ArrayList theList = this.whoIsAttackingMe();
        if (theList.size() == 0) {
            return;
        }
        if (theList.size() == 1) {
            this.setTargetId(((FighterGroup)theList.get(0)).getId());
            return;
        }
        SpaceObject largest = null;
        int size = 0;
        for (int i = 0; i < theList.size(); ++i) {
            FighterGroup efg = (FighterGroup)theList.get(i);
            if (efg.getCount() <= size) continue;
            largest = efg;
            size = efg.getCount();
        }
        if (largest != null) {
            this.setTargetId(largest.getId());
        }
    }

    public String getStatus() {
        switch (this.count) {
            case 0: {
                return "Destroyed";
            }
            case 1: {
                return "Critical";
            }
            case 2: {
                return "Heavy";
            }
            case 3: {
                return "Moderate";
            }
            case 4: {
                return "Moderate";
            }
            case 5: {
                return "Light";
            }
            case 6: {
                return "Ok";
            }
        }
        return "Ok";
    }

    public void takeDamage(int[] hits) {
        for (int i = 0; i < hits.length; ++i) {
            this.damageTaken += hits[i];
        }
        if (this.damageTaken < 0) {
            this.damageTaken = 0;
        }
    }

    public void resolveDamage(boolean endOfTurn) {
        this.count -= this.damageTaken;
        if (this.count <= 0) {
            this.count = 0;
            if (endOfTurn) {
                this.setTargetId(0);
                this.setTarget(null);
            }
        }
        this.damageTaken = 0;
    }

    public void setScreenMove() {
        Ship s;
        FighterOrders fo = this.getFighterOrders();
        if (!fo.toString().equals("Screen")) {
            return;
        }
        if (this.getTargetId() == -3) {
            s = this.getClosestFriendlyShip();
            if (s != null) {
                this.setTargetId(s.getId());
            }
        } else {
            s = this.getGameEngine().getShipById(this.getTargetId());
        }
        if (s == null) {
            return;
        }
        if (this.rangeTo(s) < 3.1) {
            this.setMayScreenMove(true);
        }
    }

    public Ship getClosestFriendlyShip() {
        ArrayList allShips = this.getGameEngine().getShips();
        Ship s = null;
        Ship result = null;
        double minRange = 999.0;
        for (int i = 0; i < allShips.size(); ++i) {
            double range;
            s = (Ship)allShips.get(i);
            if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || !this.getTeam().equals(s.getTeam()) || !((range = this.rangeTo(s)) < minRange)) continue;
            minRange = range;
            result = s;
        }
        return result;
    }

    public Ship getClosestFriendlyCarrier() {
        ArrayList allShips = this.getGameEngine().getShips();
        Ship s = null;
        Ship result = null;
        double minRange = 999.0;
        for (int i = 0; i < allShips.size(); ++i) {
            double range;
            s = (Ship)allShips.get(i);
            if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || !this.getTeam().equals(s.getTeam()) || !s.hasFighterBay() || !((range = this.rangeTo(s)) < minRange)) continue;
            minRange = range;
            result = s;
        }
        return result;
    }

    public Ship getClosestEnemyShip() {
        ArrayList allShips = this.getGameEngine().getShips();
        Ship s = null;
        Ship result = null;
        double minRange = 999.0;
        for (int i = 0; i < allShips.size(); ++i) {
            double range;
            s = (Ship)allShips.get(i);
            if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || this.getTeam().equals(s.getTeam()) || !((range = this.rangeTo(s)) < minRange)) continue;
            minRange = range;
            result = s;
        }
        return result;
    }

    public SpaceObject getClosestEnemyFighter() {
        ArrayList allObjs = this.getGameEngine().getActiveObjects();
        SpaceObject so = null;
        SpaceObject result = null;
        double minRange = 999.0;
        for (int i = 0; i < allObjs.size(); ++i) {
            double range;
            FighterGroup fg;
            so = (SpaceObject)allObjs.get(i);
            if (this.getTeam().equals(so.getTeam()) || !(so instanceof FighterGroup) || (fg = (FighterGroup)so).getCount() == 0 || !fg.hasArrived() || !((range = this.rangeTo(so)) < minRange)) continue;
            minRange = range;
            result = so;
        }
        return result;
    }

    public void fireAt() {
        String record;
        String fighters;
        FighterGroup targetGroup;
        Ship s = null;
        boolean isInterceptor = this.isAnInterceptor();
        boolean isAttack = this.isAnAttackFighter();
        boolean isTorpedo = this.isATorpedoFighter();
        boolean isDogfight = false;
        boolean isTargetHeavyFighter = false;
        int screens = 0;
        boolean isKraVak = this.getRace().equals("Kra'Vak");
        if (this.isDead() || this.hasAttacked() || this.isOnBoard()) {
            return;
        }
        this.target = this.getGameEngine().getObjectById(this.targetId);
        if (this.targetId == 0 || this.target == null) {
            return;
        }
        if (this.rangeTo(this.target) > this.getOptions().getFighterRange()) {
            return;
        }
        isDogfight = this.isTargetAFighterGroup();
        if (isInterceptor && !isDogfight) {
            return;
        }
        if (isDogfight && (targetGroup = (FighterGroup)this.target).isOnBoard()) {
            return;
        }
        if (isDogfight) {
            targetGroup = (FighterGroup)this.target;
            isTargetHeavyFighter = targetGroup.getType().isAHeavyFighter();
        }
        if (this.getGameEngine().getOptions().getFighterMorale() && this.checkMorale() > 0) {
            this.addLog("Attack", "High", "Suffered a morale failure and failed to attack.");
            return;
        }
        this.setHasAttacked(true);
        if (!this.useCombatEndurance()) {
            return;
        }
        if (isTorpedo) {
            this.spendEnduranceForTorpedo();
        }
        if (this.target instanceof MissileSalvo) {
            this.fireAtSalvo((MissileSalvo)this.target);
            return;
        }
        if (this.target instanceof PlasmaBolt) {
            this.fireAtPlasmaBolt((PlasmaBolt)this.target);
            return;
        }
        if (this.isTargetAShip() && !isKraVak) {
            s = (Ship)this.target;
            screens = s.getNumberOfActiveScreens();
        } else {
            screens = 0;
        }
        String targetName = this.target.getName();
        int[] damage = new int[2];
        int numDice = 0;
        int rerolls = 0;
        int penetration = 0;
        damage[0] = 0;
        damage[1] = 0;
        String playTestResults = " ";
        numDice = this.getCount() + (this.isAce() ? 1 : 0);
        while (numDice > 0) {
            block8: for (int i = 0; i < numDice; ++i) {
                int die = Dice.rollD6(this.getCrewQuality());
                die += isInterceptor ? 1 : 0;
                die += isAttack && !isDogfight ? 1 : 0;
                playTestResults = playTestResults + "(" + (die -= this.isTurkey() && isDogfight ? 1 : 0) + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        continue block8;
                    }
                    case 4: {
                        if (isTorpedo) {
                            if (isDogfight) continue block8;
                            damage[0] = damage[0] + 2;
                            damage[1] = damage[1] + 2;
                            continue block8;
                        }
                        if (isAttack && isDogfight || screens != 0 || isTargetHeavyFighter) continue block8;
                        int n = penetration;
                        damage[n] = damage[n] + 1;
                        continue block8;
                    }
                    case 5: {
                        if (isTorpedo) {
                            if (!isDogfight) {
                                damage[0] = damage[0] + 3;
                                damage[1] = damage[1] + 2;
                                continue block8;
                            }
                        } else {
                            if (isAttack && isDogfight) continue block8;
                            if (screens <= 1) {
                                int n = penetration;
                                damage[n] = damage[n] + 1;
                            }
                        }
                        rerolls += this.isTurkey() && isDogfight ? 1 : 0;
                        continue block8;
                    }
                    case 6: {
                        if (isTorpedo) {
                            if (!isDogfight) {
                                damage[0] = damage[0] + 3;
                                damage[1] = damage[1] + 3;
                                continue block8;
                            }
                            damage[0] = damage[0] + 1;
                        } else if (screens == 2 || isAttack && isDogfight) {
                            int n = penetration;
                            damage[n] = damage[n] + 1;
                        } else if (isKraVak) {
                            damage[0] = damage[0] + 1;
                            damage[1] = damage[1] + 1;
                        } else {
                            int n = penetration;
                            damage[n] = damage[n] + 2;
                        }
                        rerolls += isInterceptor ? 0 : 1;
                        continue block8;
                    }
                    case 7: {
                        if (isKraVak) {
                            damage[0] = damage[0] + 1;
                            damage[1] = damage[1] + 1;
                        } else {
                            int n = penetration;
                            damage[n] = damage[n] + 2;
                        }
                        ++rerolls;
                        continue block8;
                    }
                }
            }
            if (rerolls > 0) {
                numDice = rerolls;
                rerolls = 0;
                screens = 0;
                int[] temp = new int[++penetration + 2];
                System.arraycopy(damage, 0, temp, 0, damage.length);
                damage = temp;
                continue;
            }
            numDice = 0;
        }
        int totalDamage = 0;
        for (int i = 0; i < damage.length; ++i) {
            totalDamage += damage[i];
        }
        String string = fighters = this.count == 1 ? " fighter" : " fighters";
        if (totalDamage > 0) {
            String result = "";
            result = this.isTargetAShip() ? result + StringUtils.points(totalDamage) : result + StringUtils.kills(totalDamage);
            if (this.getOptions().getPlayTest()) {
                this.addLog("Attack", "High", "Hit the " + targetName + " for " + result + "." + playTestResults);
                record = "Hit for " + result + " from " + StringUtils.number(this.count) + fighters + " in " + this.getName() + "." + playTestResults;
            } else {
                this.addLog("Attack", "High", "Hit the " + targetName + " for " + result + ".");
                record = this.getName() + ": Hit for " + result + " from " + StringUtils.number(this.count) + fighters + " in " + this.getName() + ".";
            }
        } else if (this.getOptions().getPlayTest()) {
            this.addLog("Attack", "High", "Missed the " + targetName + ". " + playTestResults);
            record = "Missed with " + StringUtils.number(this.count) + fighters + " in " + this.getName() + "." + playTestResults;
        } else {
            this.addLog("Attack", "High", "Missed the " + targetName + ".");
            record = this.getName() + ": Missed with " + StringUtils.number(this.count) + fighters + " in " + this.getName() + ".";
        }
        this.target.addLog("Attack", "High", record);
        this.target.takeDamage(damage);
    }

    protected void fireAtSalvo(MissileSalvo salvo) {
        int die;
        int i;
        int dice = this.count;
        int rerolls = 0;
        int[] missilesHit = new int[1];
        int[] fightersHit = new int[1];
        missilesHit[0] = 0;
        fightersHit[0] = 0;
        while (dice > 0) {
            block5: for (i = 0; i < dice; ++i) {
                die = Dice.rollD6(this.getCrewQuality());
                switch (die) {
                    case 6: {
                        ++rerolls;
                    }
                    case 5: {
                        missilesHit[0] = missilesHit[0] + 1;
                        continue block5;
                    }
                }
            }
            if (rerolls <= 0) continue;
            dice = rerolls;
            rerolls = 0;
        }
        if (missilesHit[0] > salvo.getCount()) {
            missilesHit[0] = salvo.getCount();
        }
        for (i = 0; i < missilesHit[0]; ++i) {
            die = Dice.rollD6();
            if (die != 6) continue;
            fightersHit[0] = fightersHit[0] + 1;
        }
        if (fightersHit[0] > this.count) {
            fightersHit[0] = this.count;
        }
        if (fightersHit[0] > 0) {
            String fighters = fightersHit[0] == 1 ? " fighter" : " fighters";
            this.addLog("Damage", "High", StringUtils.number(fightersHit[0]) + fighters + " destroyed while engaging the missile salvo.");
        }
        salvo.takeDamage(missilesHit);
        this.takeDamage(fightersHit);
    }

    protected void fireAtPlasmaBolt(PlasmaBolt bolt) {
        int dice = this.count;
        int[] hits = new int[]{0};
        for (int i = 0; i < dice; ++i) {
            int die = Dice.rollD6(this.getCrewQuality());
            if (die != 6) continue;
            hits[0] = hits[0] + 1;
        }
        bolt.takeDamage(hits);
    }

    private int checkMorale() {
        int roll = Dice.rollD6();
        if (this.isAce()) {
            --roll;
        }
        if (this.isTurkey()) {
            ++roll;
        }
        this.moraleFailures = roll <= this.count ? 0 : ++this.moraleFailures;
        return this.moraleFailures;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName()).append(" ");
        buffer.append(this.fighterType.toString()).append(" fighters");
        return buffer.toString();
    }

    public String movementOrdersToXML() {
        return this.orders.toXML(this);
    }

    public String combatOrdersToXML() {
        return this.orders.toXML(this);
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        ArrayList fighterLog;
        StringBuffer result = new StringBuffer(1024);
        String newLine = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return result.toString();
        }
        result.append(this.ind(level)).append("<FighterGroup");
        if (level >= 1) {
            result.append(" id=\"");
            result.append(this.getId()).append("\">").append(newLine);
        } else {
            result.append(">").append(newLine);
        }
        if (level >= 1) {
            result.append(this.ind(level)).append(t).append("<Position ");
            result.append("x=\"");
            result.append(df.format(this.getXPosition())).append("\" ");
            result.append("y=\"");
            result.append(df.format(this.getYPosition())).append("\" ");
            result.append("/>").append(newLine);
        }
        if (level >= 1 && level < 9) {
            result.append(this.ind(level)).append(t).append("<Heading ");
            result.append("heading=\"");
            result.append(this.getHeading()).append("\" ");
            result.append("/>").append(newLine);
        }
        if (level >= 0 && level <= 5) {
            result.append(this.ind(level)).append(t);
            result.append("<Race>");
            result.append(this.getRace());
            result.append("</Race>").append(newLine);
            if (this.getIconFamily() != null) {
                result.append(this.ind(level)).append(t);
                result.append("<IconFamily value=\"");
                result.append(this.getIconFamily());
                result.append("\"/>").append(newLine);
            }
            result.append(this.ind(level)).append(t);
            result.append("<Type>");
            result.append(this.getType().toString());
            result.append("</Type>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Count>");
            result.append(this.getCount());
            result.append("</Count>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<Endurance>");
            result.append(this.getCombatEndurance());
            result.append("</Endurance>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<PilotQuality>");
            result.append(this.getPilotQuality());
            result.append("</PilotQuality>").append(newLine);
            result.append(this.ind(level)).append(t);
            result.append("<DogFighting value=\"");
            result.append(this.isDogfighting());
            result.append("\"/>").append(newLine);
            if (this.getCarrierShipId() != 0) {
                result.append(this.ind(level)).append(t);
                result.append("<Carrier id=\"");
                result.append(this.getCarrierShipId());
                result.append("\"/>").append(newLine);
            }
            result.append(this.ind(level)).append(t);
            result.append("<OnBoard value=\"");
            result.append(this.isOnBoard());
            result.append("\"/>").append(newLine);
            if (this.getFighterBayId() != 0) {
                result.append(this.ind(level)).append(t);
                result.append("<FighterBay id=\"");
                result.append(this.getFighterBayId());
                result.append("\"/>").append(newLine);
            }
            result.append(this.ind(level)).append(t);
            result.append("<Target");
            result.append(" id=\"");
            result.append(this.getTargetId()).append("\"/>").append(newLine);
            result.append(this.getFighterOrders().toXML(this, 3));
        }
        if ((level == 1 || level == 2 || level == 3) && (fighterLog = this.getLog()).size() > 0) {
            result.append(t).append(t).append(t);
            result.append("<Log>").append(newLine);
            for (int i = 0; i < fighterLog.size(); ++i) {
                LogRecord l = (LogRecord)fighterLog.get(i);
                result.append(l.toXML(level));
            }
            result.append(t).append(t).append(t);
            result.append("</Log>").append(newLine);
        }
        result.append(this.ind(level)).append("</FighterGroup>");
        result.append(newLine);
        return result.toString();
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    static {
        orderChoices.add(0, new FighterOrders(){

            public String getBriefDescription() {
                return "Move";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "In transit.  Defend if engaged.";
            }

            public void doMove(FighterGroup fg) {
                boolean secondaryMovePhase = false;
                this.moveToOrderedPosition(fg, secondaryMovePhase);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                if (fg.getCombatEndurance() == 0) {
                    return;
                }
                if (fg.isATorpedoFighter() && fg.getCombatEndurance() <= 1) {
                    return;
                }
                fg.defendIfAttacked();
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                if (fg.isAnAttackFighter() || fg.isATorpedoFighter()) {
                    return;
                }
                ArrayList tLt = fg.whoIsInMyAttackRange();
                FighterGroup efg = fg.whoIsThePriorityTarget(tLt);
                if (efg == null) {
                    return;
                }
                fg.setTargetId(efg.getId());
            }

            public void doSecondaryMove(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                this.moveToOrderedPosition(fg, true);
            }

            public void doCombat(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    fg.fireAt();
                }
            }
        });
        orderChoices.add(1, new FighterOrders(){

            public String getBriefDescription() {
                return "Stand-off";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Avoid enemy contact.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.defendIfAttacked();
            }

            public void doSecondaryMove(FighterGroup fg) {
            }

            public void doCombat(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    fg.fireAt();
                }
            }
        });
        orderChoices.add(2, new FighterOrders(){

            public String getBriefDescription() {
                return "Screen";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Screen friendly ship.";
            }

            public void doMove(FighterGroup fg) {
                if (fg.isLaunching()) {
                    fg.addLog("Status", "Medium", fg.getName() + " has launched.");
                }
                this.moveToScreenShip(fg);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.defendIfAttacked();
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                if (fg.isMyScreenedShipBeingAttacked()) {
                    ArrayList tLt = fg.whoIsAttackingMyScreenedShip();
                    FighterGroup efg = fg.whoIsThePriorityTarget(tLt);
                    fg.setTargetId(efg.getId());
                    double range = fg.rangeTo(efg);
                    if (range > fg.getOptions().getFighterRange()) {
                        fg.setXPosition(efg.getXPosition());
                        fg.setYPosition(efg.getYPosition());
                    }
                }
            }

            public void doSecondaryMove(FighterGroup fg) {
            }

            public void doCombat(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    fg.fireAt();
                }
            }
        });
        orderChoices.add(3, new FighterOrders(){

            public String getBriefDescription() {
                return "Attack Target";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Attack enemy target. Use combat move if ordered.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.lockOnToTargetShip(second);
                if (fg.isMyTargetInAttackRange()) {
                    return;
                }
                if (second) {
                    fg.defendIfAttacked();
                }
            }

            public void doSecondaryMove(FighterGroup fg) {
                this.closeToTarget(fg);
            }

            public void doCombat(FighterGroup fg) {
                fg.fireAt();
            }
        });
        orderChoices.add(4, new FighterOrders(){

            public String getBriefDescription() {
                return "Aggressive Attack";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Attack highest priority enemy target. Use combat move if necessary.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.lockOnToTargetShip(second);
                if (fg.isMyTargetInAttackRange()) {
                    return;
                }
                if (second) {
                    fg.defendIfAttacked();
                }
            }

            public void doSecondaryMove(FighterGroup fg) {
                this.closeToTarget(fg);
            }

            public void doCombat(FighterGroup fg) {
                fg.fireAt();
            }
        });
        orderChoices.add(5, new FighterOrders(){

            public String getBriefDescription() {
                return "Conservative Attack";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Attack highest priority enemy target. Do not use combat move.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.lockOnToTargetShip(second);
                if (fg.isMyTargetInAttackRange()) {
                    return;
                }
                if (second) {
                    fg.defendIfAttacked();
                }
            }

            public void doSecondaryMove(FighterGroup fg) {
            }

            public void doCombat(FighterGroup fg) {
                fg.fireAt();
            }
        });
        orderChoices.add(6, new FighterOrders(){

            public String getBriefDescription() {
                return "Engage Fighters";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Attack highest priority enemy fighters.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                ArrayList tLt;
                FighterGroup efg;
                if (fg.isMyTargetInAttackRange()) {
                    return;
                }
                if (second) {
                    fg.defendIfAttacked();
                }
                if ((efg = fg.whoIsThePriorityTarget(tLt = fg.whoIsInMyAttackRange())) == null) {
                    return;
                }
                fg.setTargetId(efg.getId());
            }

            public void doSecondaryMove(FighterGroup fg) {
                this.closeToTarget(fg);
            }

            public void doCombat(FighterGroup fg) {
                fg.fireAt();
            }
        });
        orderChoices.add(7, new FighterOrders(){

            public String getBriefDescription() {
                return "Engage Ranged Weapons";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Attack highest priority enemy ranged weapon.";
            }

            public void doMove(FighterGroup fg) {
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                if (!second) {
                    return;
                }
                if (second && fg.isMyTargetInAttackRange()) {
                    return;
                }
                fg.defendIfAttacked();
            }

            public void doSecondaryMove(FighterGroup fg) {
                this.closeToTarget(fg);
            }

            public void doCombat(FighterGroup fg) {
                fg.fireAt();
            }
        });
        orderChoices.add(8, new FighterOrders(){

            public String getBriefDescription() {
                return "Return Home";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Return to home carrier.";
            }

            public void doMove(FighterGroup fg) {
                this.setDestinationToCarrier(fg, false);
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.defendIfAttacked();
            }

            public void doSecondaryMove(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                this.moveToOrderedPosition(fg, true);
            }

            public void doCombat(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    fg.fireAt();
                }
            }
        });
        orderChoices.add(9, new FighterOrders(){

            public String getBriefDescription() {
                return "Emergency Landing";
            }

            public String toString() {
                return this.getBriefDescription();
            }

            public String getDescription() {
                return "Return to closest friendly carrier.";
            }

            public void doMove(FighterGroup fg) {
                this.setDestinationToCarrier(fg, true);
                this.moveToOrderedPosition(fg, false);
            }

            public void doReaction(FighterGroup fg, boolean second) {
                fg.defendIfAttacked();
            }

            public void doSecondaryMove(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    return;
                }
                this.moveToOrderedPosition(fg, true);
            }

            public void doCombat(FighterGroup fg) {
                if (fg.isTargetAFighterGroup()) {
                    fg.fireAt();
                }
            }
        });
    }
}

