/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

public class FighterGroupType {
    public static final String STANDARD_TYPE = "Standard";
    public static final String HEAVY_TYPE = "Heavy";
    public static final String FAST_TYPE = "Fast";
    public static final String INTERCEPTOR_TYPE = "Interceptor";
    public static final String ATTACK_TYPE = "Attack";
    public static final String LONG_RANGE_TYPE = "Long Range";
    public static final String TORPEDO_TYPE = "Torpedo";
    public static final String NEEDLE_TYPE = "Needle";
    public static final int STANDARD_SPEED = 0;
    public static final int FAST_SPEED = 1;
    public static final int STANDARD_RANGE = 0;
    public static final int LONG_RANGE = 1;
    public static final int STANDARD_DEFENSE = 0;
    public static final int HEAVY_DEFENSE = 1;
    public static final int STANDARD_ATTACK = 0;
    public static final int INTERCEPTOR_ATTACK = 1;
    public static final int ATTACK_ATTACK = 2;
    public static final int TORPEDO_ATTACK = 3;
    public static final int NEEDLE_ATTACK = 4;
    private int speed = 0;
    private int defense = 0;
    private int attack = 0;
    private int range = 0;

    public FighterGroupType() {
    }

    public FighterGroupType(String a) {
        this();
        this.setType(a);
    }

    public void setType(String input) {
        if (input.equals(STANDARD_TYPE)) {
            return;
        }
        if (input.indexOf(FAST_TYPE) != -1) {
            this.setFast();
        }
        if (input.indexOf(HEAVY_TYPE) != -1) {
            this.setHeavy();
        }
        if (input.indexOf(LONG_RANGE_TYPE) != -1) {
            this.setLongRange();
        }
        if (input.indexOf(INTERCEPTOR_TYPE) != -1) {
            this.setInterceptor();
        } else if (input.indexOf(ATTACK_TYPE) != -1) {
            this.setAttack();
        } else if (input.indexOf(TORPEDO_TYPE) != -1) {
            this.setTorpedo();
        } else if (input.indexOf(NEEDLE_TYPE) != -1) {
            this.setNeedle();
        }
    }

    private void setFast() {
        this.speed = 1;
    }

    private void setHeavy() {
        this.defense = 1;
    }

    private void setLongRange() {
        this.range = 1;
    }

    private void setInterceptor() {
        this.attack = 1;
    }

    private void setAttack() {
        this.attack = 2;
    }

    private void setTorpedo() {
        this.attack = 3;
    }

    private void setNeedle() {
        this.attack = 4;
    }

    public boolean isAStandardFighter() {
        boolean test = this.speed == 0 && this.defense == 0 && this.attack == 0 && this.range == 0;
        return test;
    }

    public boolean isAFastFighter() {
        return this.speed == 1;
    }

    public boolean isALongRangeFighter() {
        return this.range == 1;
    }

    public boolean isAHeavyFighter() {
        return this.defense == 1;
    }

    public boolean isAnInterceptor() {
        return this.attack == 1;
    }

    public boolean isAnAttackFighter() {
        return this.attack == 2;
    }

    public boolean isATorpedoFighter() {
        return this.attack == 3;
    }

    public boolean isANeedleFighter() {
        return this.attack == 4;
    }

    public int computePointCost() {
        int cost = 18;
        if (this.isAFastFighter()) {
            cost += 12;
        }
        if (this.isALongRangeFighter()) {
            cost += 12;
        }
        if (this.isAHeavyFighter()) {
            cost += 12;
        }
        if (this.isAnInterceptor()) {
            cost += 0;
        }
        if (this.isAnAttackFighter()) {
            cost += 6;
        }
        if (this.isATorpedoFighter()) {
            cost += 18;
        }
        if (this.isANeedleFighter()) {
            cost += 24;
        }
        return cost;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isAStandardFighter()) {
            buffer.append(STANDARD_TYPE);
        }
        if (this.isAFastFighter()) {
            buffer.append(FAST_TYPE).append(" ");
        }
        if (this.isALongRangeFighter()) {
            buffer.append(LONG_RANGE_TYPE).append(" ");
        }
        if (this.isAHeavyFighter()) {
            buffer.append(HEAVY_TYPE).append(" ");
        }
        switch (this.attack) {
            case 1: {
                buffer.append(INTERCEPTOR_TYPE);
                break;
            }
            case 2: {
                buffer.append(ATTACK_TYPE);
                break;
            }
            case 3: {
                buffer.append(TORPEDO_TYPE);
                break;
            }
            case 4: {
                buffer.append(NEEDLE_TYPE);
            }
        }
        return buffer.toString().trim();
    }
}

