/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;

public class GameUtilities {
    private GameUtilities() {
    }

    public static boolean skipCombatPhase(GameEngine gEngine) {
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (!GameUtilities.canSpaceObjectAttack(gEngine, sObject)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpaceObjectAttack(GameEngine gEngine, SpaceObject sObject) {
        if (sObject instanceof AntiMatterTorpedo) {
            return GameUtilities.canAntiMatterTorpedoAttack(gEngine, (AntiMatterTorpedo)sObject);
        }
        if (sObject instanceof FighterGroup) {
            return GameUtilities.canFighterGroupAttack(gEngine, (FighterGroup)sObject);
        }
        if (sObject instanceof MissileSalvo) {
            return GameUtilities.canMissileSalvoAttack(gEngine, (MissileSalvo)sObject);
        }
        if (sObject instanceof NovaCannonBolt) {
            return true;
        }
        if (sObject instanceof PlasmaBolt) {
            return GameUtilities.canPlasmaBoltAttack(gEngine, (PlasmaBolt)sObject);
        }
        if (sObject instanceof Ship) {
            return GameUtilities.canShipAttack(gEngine, (Ship)sObject);
        }
        return sObject instanceof WaveGunBolt;
    }

    private static boolean canAntiMatterTorpedoAttack(GameEngine gEngine, AntiMatterTorpedo aTorpedo) {
        double lockOnRange = gEngine.getOptions().getAntiMatterTorpedoLockOnRange();
        double blastRange = gEngine.getOptions().getAntiMatterTorpedoBlastRange();
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            Ship aShip;
            double range;
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (aTorpedo.getId() == sObject.getId() || (range = aTorpedo.rangeTo(sObject)) > blastRange + lockOnRange) continue;
            if (range < blastRange) {
                return true;
            }
            if (!(sObject instanceof Ship) || (aShip = (Ship)sObject).isDestroyed() || aShip.hasJumped() || aShip.getTeam().equals(aTorpedo.getTeam()) || !(aTorpedo.rangeTo(aShip) <= lockOnRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean canFighterGroupAttack(GameEngine gEngine, FighterGroup aFighter) {
        double attackRange = gEngine.getOptions().getFighterRange();
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (aFighter.getId() == sObject.getId() || aFighter.getTeam().equals(sObject.getTeam()) || !(aFighter.rangeTo(sObject) <= attackRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean canMissileSalvoAttack(GameEngine gEngine, MissileSalvo aSalvo) {
        double attackRange = gEngine.getOptions().getSalvoMissileLockOn();
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (aSalvo.getId() == sObject.getId() || aSalvo.getTeam().equals(sObject.getTeam()) || !(aSalvo.rangeTo(sObject) <= attackRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean canPlasmaBoltAttack(GameEngine gEngine, PlasmaBolt aBolt) {
        double attackRange = gEngine.getOptions().getPlasmaBoltBlastRange();
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (aBolt.getId() == sObject.getId() || !(aBolt.rangeTo(sObject) <= attackRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean canShipAttack(GameEngine gEngine, Ship aShip) {
        double attackRange = 4.0 * gEngine.getOptions().getBeamRangeBand();
        int count = gEngine.getActiveObjects().size();
        for (int i = 0; i < count; ++i) {
            SpaceObject sObject = (SpaceObject)gEngine.getActiveObjects().get(i);
            if (aShip.getId() == sObject.getId() || aShip.getTeam().equals(sObject.getTeam()) || !(aShip.rangeTo(sObject) <= attackRange)) continue;
            return true;
        }
        return false;
    }
}

