/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class HangerBay
extends Weapon {
    private int hangerSize;

    public HangerBay() {
        this(6);
    }

    public HangerBay(int a) {
        this.setArcs(0);
        this.hangerSize = a;
        this.setSystemName("Hanger Bay (" + this.hangerSize + ")");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void setHangerSize(int a) {
        this.hangerSize = a;
    }

    public int getHangerSize() {
        return this.hangerSize;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("size")) {
            this.hangerSize = Integer.parseInt(Value);
            handled = true;
        }
        this.setSystemName("Hanger Bay (" + this.hangerSize + ")");
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public int computeMass() {
        return (int)Math.ceil(1.5 * (double)this.hangerSize);
    }

    public int computePointCost() {
        int bayPoints = 3 * this.computeMass();
        int craftPoints = 2 * this.hangerSize;
        return bayPoints + craftPoints;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<HangerBay");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" size=\"" + this.getHangerSize() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("HangerBay", new HangerBay());
    }
}

