/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.MissileLauncher;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.MathUtil;
import ftjava.util.MovementSteps;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Iterator;

public class Missile
extends SpaceObject {
    public static final String STANDARD = "Standard";
    public static final String EMP = "EMP";
    public static final String NEEDLE = "Needle";
    private String type = "Standard";
    private SpaceObject target = null;
    private int endurance = 3;
    private int launchingShipId = 0;
    private int launcherId = 0;
    private int targetId = 0;
    private int needleTargetId = -1;
    private boolean hasAttacked = false;
    private int moveRate;
    private int turnRate;

    public void setName() {
        super.setName("M" + this.getId());
    }

    public String getTeam() {
        return super.getTeam();
    }

    public Player getPlayer() {
        Ship s;
        Player p = null;
        GameEngine g = this.getGameEngine();
        if (g != null && (s = g.getShipById(this.launchingShipId)) != null) {
            return s.getPlayer();
        }
        return p;
    }

    public void setEndurance(int t) {
        this.endurance = t;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
    }

    public SpaceObject getTarget() {
        if ((this.target == null || this.target.getId() != this.targetId) && this.getGameEngine() != null) {
            this.target = this.getGameEngine().getObjectById(this.targetId);
        }
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setNeedleTargetId(int t) {
        this.needleTargetId = t;
    }

    public int getNeedleTargetId() {
        return this.needleTargetId;
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getType() {
        return this.type;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    public int getMove() {
        return this.moveRate;
    }

    public void setMove(int move) {
        this.moveRate = move;
    }

    public int getTurn() {
        return this.turnRate;
    }

    public void setTurn(int turn) {
        this.turnRate = turn;
    }

    public boolean isDestroyed() {
        return this.getStatus().equals("Destroyed");
    }

    public int getMaximumRange() {
        return 18;
    }

    public void setOriginalPosition() {
        this.setPastX(this.getXPosition());
        this.setPastY(this.getYPosition());
        this.setPastHeading(this.getHeading());
    }

    public void resetOriginalPosition() {
        this.setPosition(this.getPastX(), this.getPastY());
        this.setHeading(this.getPastHeading());
    }

    public Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    public MissileLauncher getLauncher() {
        Ship s = this.getLaunchingShip();
        if (s == null) {
            return null;
        }
        Weapon w = s.getWeaponById(this.launcherId);
        return (MissileLauncher)w;
    }

    public double getPlottedXPosition() {
        return this.getPlottedXPosition(this.moveRate, this.turnRate);
    }

    public double getPlottedXPosition(int move, int turn) {
        MovementSteps ms = this.getMovementSteps(move, turn);
        return this.getXPosition() + ms.First[0] + ms.Second[0];
    }

    public double getPlottedYPosition() {
        return this.getPlottedYPosition(this.moveRate, this.turnRate);
    }

    public double getPlottedYPosition(int move, int turn) {
        MovementSteps ms = this.getMovementSteps(move, turn);
        return this.getYPosition() + ms.First[1] + ms.Second[1];
    }

    public int getPlottedHeading() {
        return this.getPlottedHeading(this.moveRate, this.turnRate);
    }

    public int getPlottedHeading(int move, int turn) {
        MovementSteps ms = this.getMovementSteps(move, turn);
        int heading = ms.Heading[1];
        if (heading <= 0) {
            heading += 12;
        }
        if (heading > 12) {
            heading -= 12;
        }
        return heading;
    }

    public MovementSteps getMovementSteps() {
        return this.getMovementSteps(this.moveRate, this.turnRate);
    }

    public MovementSteps getMovementSteps(int move, int turn) {
        MovementSteps ms = new MovementSteps();
        ms.MovementType = MovementSteps.MISSILE_MOVEMENT;
        ms.SpeedChange = 0;
        ms.Roll = false;
        ms.Jumping = false;
        ms.Striking = false;
        ms.Valid = true;
        ms.First[0] = (double)move / 2.0 * Math.sin(MathUtil.toRadians((double)this.getHeading() * 30.0));
        ms.First[1] = (double)move / 2.0 * Math.cos(MathUtil.toRadians((double)this.getHeading() * 30.0));
        ms.Heading[0] = this.getHeading();
        ms.Second[0] = (double)move / 2.0 * Math.sin(MathUtil.toRadians((double)(this.getHeading() + turn) * 30.0));
        ms.Second[1] = (double)move / 2.0 * Math.cos(MathUtil.toRadians((double)(this.getHeading() + turn) * 30.0));
        ms.Heading[1] = this.getHeading() + Math.round(turn);
        for (int i = 0; i < ms.Heading.length; ++i) {
            if (ms.Heading[i] <= 0) {
                int n = i;
                ms.Heading[n] = ms.Heading[n] + 12;
            }
            if (ms.Heading[i] <= 0) continue;
            int n = i;
            ms.Heading[n] = ms.Heading[n] - 12;
        }
        return ms;
    }

    public void move() {
        MovementSteps ms = this.getMovementSteps();
        this.setXPosition(this.getXPosition() + ms.First[0] + ms.Second[0]);
        this.setYPosition(this.getYPosition() + ms.First[1] + ms.Second[1]);
        int heading = ms.Heading[1];
        if (heading <= 0) {
            heading += 12;
        }
        if (heading > 12) {
            heading -= 12;
        }
        this.setHeading(heading);
    }

    public void takeDamage(int[] hits) {
        int damage = 0;
        for (int i = 0; i < hits.length; ++i) {
            damage += hits[i];
        }
        if (damage > 0) {
            this.setStatus("Destroyed");
            this.setEndurance(0);
        }
    }

    public void acquireTarget(ArrayList allShips, double lockOnRange) {
        Ship s;
        SpaceObject bestShipSoFar = null;
        double bestShipRange = lockOnRange;
        MissileLauncher launcher = this.getLauncher();
        if (this.targetId > 0 && (s = this.getGameEngine().getShipById(this.targetId)) != null) {
            if (this.canAttack(s, lockOnRange)) {
                return;
            }
            if (this.getEndurance() > 0) {
                return;
            }
        }
        for (int i = 0; i < allShips.size(); ++i) {
            double thisRange;
            Ship s2;
            SpaceObject o = (SpaceObject)allShips.get(i);
            if (!(o instanceof Ship) || (s2 = (Ship)o).isDestroyed() || s2.hasJumped() || s2.getTeam().equals(this.getTeam()) || !s2.hasArrived() || (thisRange = this.rangeTo(s2) * s2.getRangeStealthModifier()) > lockOnRange || this.arcTo(s2) == Weapon.AFT_ARC || bestShipSoFar != null && thisRange >= bestShipRange) continue;
            bestShipSoFar = s2;
            bestShipRange = thisRange;
        }
        if (bestShipSoFar != null) {
            this.setTarget(bestShipSoFar);
            this.setTargetId(bestShipSoFar.getId());
            this.target.addLog("Attack", "Medium", this.getName() + ": Missile targeting.");
            launcher.setNotes("Targeting " + this.target.getName());
        } else {
            launcher.setNotes("No targets in range.");
        }
    }

    public boolean canAttack(Ship s, double lockOnRange) {
        return this.rangeTo(s) * s.getRangeStealthModifier() < lockOnRange && this.arcTo(s) != Weapon.AFT_ARC;
    }

    public void fireAt() {
        String playTestResults = "";
        MissileLauncher launcher = this.getLauncher();
        this.target = this.getGameEngine().getShipById(this.targetId);
        if (this.targetId == 0 || this.target == null) {
            return;
        }
        if (launcher == null) {
            throw new RuntimeException("No launcher for Missile");
        }
        if (this.isDestroyed()) {
            return;
        }
        Ship s = (Ship)this.target;
        if (!this.canAttack(s, this.getGameEngine().getOptions().getMissileLockOnRange())) {
            return;
        }
        this.setHasAttacked(true);
        String targetName = this.target.getName();
        StringBuffer attackRecord = new StringBuffer();
        attackRecord.append(this.getType()).append(" missile M").append(this.getId());
        attackRecord.append(" attacked the ").append(targetName);
        int[] damageArray = new int[]{0};
        if (this.getType().equals(EMP)) {
            String status;
            ShipSystem ss;
            int requiredRoll = 7;
            int roll = Dice.rollD6();
            switch (roll -= s.getNumberOfActiveScreens()) {
                case 3: 
                case 4: {
                    requiredRoll = 5;
                    break;
                }
                case 5: 
                case 6: {
                    requiredRoll = 4;
                    break;
                }
            }
            int count = 0;
            Iterator i = s.getElectronicsSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (!ss.isOperational() && !ss.isExpended()) continue;
                ss.takeThresholdCheck(requiredRoll);
                count += ss.isDamaged() ? 1 : 0;
            }
            i = s.getDefenseSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (!ss.isOperational() && !ss.isExpended()) continue;
                ss.takeThresholdCheck(requiredRoll);
                count += ss.isDamaged() ? 1 : 0;
            }
            i = s.getWeaponSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (!ss.isOperational() && !ss.isExpended()) continue;
                ss.takeThresholdCheck(requiredRoll);
                count += ss.isDamaged() ? 1 : 0;
            }
            if (s.getMainDrive() != null) {
                status = s.getMainDrive().getSystemStatus();
                s.getMainDrive().takeThresholdCheck(requiredRoll);
                count += status.equals(s.getMainDrive().getSystemStatus()) ? 0 : 1;
            }
            if (s.getFTLDrive() != null) {
                status = s.getMainDrive().getSystemStatus();
                s.getFTLDrive().takeThresholdCheck(requiredRoll);
                count += status.equals(s.getFTLDrive().getSystemStatus()) ? 0 : 1;
            }
            if (count > 0) {
                attackRecord.append(" and damaged ");
                attackRecord.append(count).append(" systems");
            } else {
                attackRecord.append(" and had no effect!");
            }
        } else if (this.getType().equals(NEEDLE)) {
            ShipSystem ss = s.getShipSystemById(this.getNeedleTargetId());
            if (ss == null && this.getNeedleTargetId() == s.getMainDrive().getId()) {
                ss = s.getMainDrive();
            }
            if (ss == null && this.getNeedleTargetId() == s.getFTLDrive().getId()) {
                ss = s.getFTLDrive();
            }
            if (ss != null) {
                int roll = Dice.rollD6();
                switch (roll) {
                    case 4: 
                    case 5: 
                    case 6: {
                        ss.setSystemStatus("Destroyed");
                        attackRecord.append(", destroyed a ");
                        break;
                    }
                    default: {
                        attackRecord.append(", missed a ");
                    }
                }
                attackRecord.append(ss.getSystemName());
                attackRecord.append(" and ");
            } else {
                attackRecord.append(", had no system targeted and ");
            }
            damageArray[0] = Dice.rollD6();
            attackRecord.append("hit for ");
            attackRecord.append(StringUtils.points(damageArray[0]));
        } else {
            damageArray[0] = Dice.rollD6() + Dice.rollD6();
            attackRecord.append(" and hit for ");
            attackRecord.append(StringUtils.points(damageArray[0]));
        }
        if (this.getOptions().getPlayTest()) {
            attackRecord.append(playTestResults);
        }
        String record = attackRecord.append(".").toString();
        launcher.setNotes(record);
        this.target.addLog("Attack", "High", record);
        s.takeDamage(damageArray);
        if (damageArray[0] >= 10) {
            GameEngine ge = this.getGameEngine();
            ge.addTurnReport("Attack", "High", record);
        }
    }

    public String getAction() {
        Ship s = null;
        SpaceObject target = this.getGameEngine().getObjectById(this.targetId);
        if (target instanceof Ship) {
            s = (Ship)target;
        }
        if (s == null) {
            return "In flight";
        }
        StringBuffer sb = new StringBuffer("Attacking ");
        sb.append(s.getClassAbbrev());
        sb.append(" ");
        sb.append(s.getName());
        return sb.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        sb.append(t).append(t);
        sb.append("<Missile id=\"");
        sb.append(this.getId());
        sb.append("\" shipId=\"");
        sb.append(this.getLaunchingShipId());
        sb.append("\" launcherId=\"");
        sb.append(this.getLauncherId());
        sb.append("\" type=\"");
        sb.append(this.getType());
        sb.append("\" x=\"");
        sb.append(this.getXPosition());
        sb.append("\" y=\"");
        sb.append(this.getYPosition());
        sb.append("\" heading=\"");
        sb.append(this.getHeading());
        sb.append("\" endurance=\"");
        sb.append(this.getEndurance());
        sb.append("\" targetId=\"");
        sb.append(this.getTargetId());
        if (this.getType().equals(NEEDLE) && this.needleTargetId > 0) {
            sb.append("\" needleTargetId=\"");
            sb.append(this.getNeedleTargetId());
        }
        sb.append("\"/>");
        sb.append(sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        sb.append(t).append(t);
        sb.append("<Missile id=\"");
        sb.append(this.getId());
        sb.append("\" shipId=\"");
        sb.append(this.getLaunchingShipId());
        sb.append("\" launcherId=\"");
        sb.append(this.getLauncherId());
        sb.append("\" move=\"");
        sb.append(this.getMove());
        sb.append("\" turn=\"");
        sb.append(this.getTurn());
        if (this.getTargetId() != 0) {
            sb.append("\" targetId=\"");
            sb.append(this.getTargetId());
        }
        sb.append("\"/>");
        sb.append(sep);
        return sb.toString();
    }

    public String combatOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        if (this.getType().equals(NEEDLE) && this.needleTargetId > 0) {
            sb.append(t).append(t);
            sb.append("<Missile id=\"");
            sb.append(this.getId());
            sb.append("\" needleTargetId=\"");
            sb.append(this.getNeedleTargetId());
            sb.append("\"/>");
            sb.append(sep);
        }
        return sb.toString();
    }
}

