/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Missile;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class MissileLauncher
extends Weapon {
    private String type;

    public MissileLauncher() {
        this(Weapon.FRONT_ARCS);
    }

    public MissileLauncher(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public MissileLauncher(int a) {
        this.setArcs(a);
        this.setType("Standard");
        this.updateSystemName();
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public MissileLauncher(String t, int a) {
        this.setType(t);
        this.setArcs(a);
        this.updateSystemName();
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
        } else if (Name.equals("type")) {
            this.setType(Value);
        } else {
            super.setValue(Name, Value);
        }
        this.updateSystemName();
    }

    public void setType(String t) {
        this.type = t.equals("EMP") || t.equals("Needle") ? t : "Standard";
        this.updateSystemName();
    }

    public String getType() {
        return this.type;
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, Missile m) {
        if (!this.getSystemStatus().equals("Operational")) {
            this.setNotes("Weapon is not operational.");
            return false;
        }
        if (this.hasFired()) {
            this.setNotes("Weapon has fired already!");
            return false;
        }
        double range = firer.rangeTo(m);
        if (range > 1.0) {
            this.setNotes("Launch point is out of range.");
            return false;
        }
        if (firer.getHeading() != m.getHeading()) {
            this.setNotes("Launch heading must match.");
            return false;
        }
        if (!this.getType().equals(m.getType())) {
            this.setNotes("Launcher/Missile type mismatch.");
            return false;
        }
        return true;
    }

    public void fireMissile(SpaceObject firer, Missile m) {
        this.setFired();
        this.setExpended();
    }

    public int computeMass() {
        return 2;
    }

    public int computePointCost() {
        return 3 * this.computeMass();
    }

    private void updateSystemName() {
        if (this.type.equals("EMP")) {
            this.setSystemName("Missile (EMP)   ");
        } else if (this.type.equals("Needle")) {
            this.setSystemName("Missile (Needle)");
        } else {
            this.setSystemName("Missile         ");
        }
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<MissileLauncher");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" type=\"" + this.getType() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("MissileLauncher", new MissileLauncher());
    }
}

