/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class NeedleBeam
extends Weapon {
    private static String ELECTRONICS;
    private static String DRIVES;
    private static String WEAPONS;
    private static String DEFENSES;

    public NeedleBeam() {
        this(Weapon.FORE_ARC);
    }

    public NeedleBeam(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public NeedleBeam(int a) {
        this.setArcs(a);
        this.setSystemName("Needle Beam " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(this.getOptions().getNeedleBeamRange());
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Needle Beam " + this.getArcsString());
        } else {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        this.fireAt(firer, target, ELECTRONICS);
    }

    public void fireAt(SpaceObject firer, SpaceObject target, String targetSystem) {
        String record;
        ArrayList<ShipSystem> targetList = new ArrayList<ShipSystem>();
        DecimalFormat df = new DecimalFormat("0.0");
        if (!this.isRecharged()) {
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        double rangeBand = this.getOptions().getNeedleBeamRange();
        if (firer.rangeTo(target) > rangeBand) {
            return;
        }
        this.setFired();
        String targetName = target.getName();
        int die = Dice.rollD6();
        boolean hit = false;
        if (range < rangeBand && die >= 5) {
            hit = true;
        }
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        playTestResults = playTestResults + "(" + die + ") ";
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + "." + playTestResults);
                record2 = firer.getName() + " missed with a needle beam." + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a needle beam.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        if (die == 5) {
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Hit the " + targetName + " for one point." + playTestResults);
                record = firer.getName() + " hit for one point with a needle beam." + playTestResults;
            } else {
                this.setNotes("Hit the " + targetName + " for one point.");
                record = firer.getName() + " hit for one point with a needle beam.";
            }
            target.addLog("Attack", "High", record);
        }
        if (die == 6) {
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Hit the " + targetName + " for one point. System destroyed." + playTestResults);
                record = firer.getName() + " destroyed a " + targetSystem + " system with a needle beam." + playTestResults;
            } else {
                this.setNotes("Hit the " + targetName + " for one point. System destroyed.");
                record = firer.getName() + " destroyed a " + targetSystem + " system with a needle beam.";
            }
            target.addLog("Attack", "Urgent", record);
        }
        Ship s = (Ship)target;
        s.takeDamage(new int[]{0, 1});
        if (die == 5) {
            return;
        }
        targetList = new ArrayList();
        if (targetSystem.equals(DRIVES)) {
            targetList.add(s.getMainDrive());
            targetList.add(s.getFTLDrive());
            targetList.addAll(s.getElectronicsSystems());
            targetList.addAll(s.getWeaponSystems());
            targetList.addAll(s.getDefenseSystems());
        } else if (targetSystem.equals(WEAPONS)) {
            targetList.addAll(s.getWeaponSystems());
            targetList.addAll(s.getElectronicsSystems());
            targetList.add(s.getMainDrive());
            targetList.add(s.getFTLDrive());
            targetList.addAll(s.getDefenseSystems());
        } else if (targetSystem.equals(DEFENSES)) {
            targetList.addAll(s.getDefenseSystems());
            targetList.addAll(s.getElectronicsSystems());
            targetList.add(s.getMainDrive());
            targetList.add(s.getFTLDrive());
            targetList.addAll(s.getWeaponSystems());
        } else {
            targetList.addAll(s.getElectronicsSystems());
            targetList.add(s.getMainDrive());
            targetList.add(s.getFTLDrive());
            targetList.addAll(s.getWeaponSystems());
            targetList.addAll(s.getDefenseSystems());
        }
        for (int i = 0; i < targetList.size(); ++i) {
            Object o = targetList.get(i);
            ShipSystem sys = (ShipSystem)o;
            if (sys.getSystemStatus().equals("Destroyed")) continue;
            sys.setDestroyed();
            return;
        }
    }

    public int computeMass() {
        return 2;
    }

    public int computePointCost() {
        return 6;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<NeedleBeam");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"" + this.getArcsString() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("NeedleBeam", new NeedleBeam());
        ELECTRONICS = "Electronics";
        DRIVES = "Drives";
        WEAPONS = "Weapons";
        DEFENSES = "Defenses";
    }
}

