/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.NovaCannonBolt;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class NovaCannon
extends Weapon {
    public NovaCannon() {
        this(Weapon.FRONT_ARCS);
    }

    public NovaCannon(int a) {
        this.setArcs(a);
        this.setFireRate(2);
        this.setSystemName("Nova Cannon " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            handled = true;
        }
        if (Name.equals("recharge")) {
            this.setRecharge(Integer.valueOf(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        } else {
            this.setSystemName("Nova Cannon " + this.getArcsString());
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, NovaCannonBolt ncb) {
        if (!this.getSystemStatus().equals("Operational")) {
            return false;
        }
        if (this.hasFired()) {
            return false;
        }
        return this.isRecharged();
    }

    public void fireBolt(SpaceObject firer, NovaCannonBolt ncb) {
        this.setFired();
    }

    public boolean hasFired() {
        int timeToRecharge = this.getRecharge();
        return timeToRecharge == this.getFireRate() - 1;
    }

    public int computeMass() {
        return 16;
    }

    public int computePointCost() {
        return 50;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<NovaCannon");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            sb.append(" recharge=\"" + this.getRecharge() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("NovaCannon", new NovaCannon());
    }
}

