/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.HeavenlyBody;
import ftjava.std.Message;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;
import ftjava.util.UserPreferences;
import ftjava.util.XMLUtilities;
import java.awt.Color;
import java.util.ArrayList;

public class Player {
    private static int idCounter = 0;
    protected String name = "";
    protected int id;
    protected String email = "";
    protected String team = "None";
    private String objectives = "";
    public ArrayList Ships;
    public ArrayList SpaceObjects;
    protected ArrayList incomingMessageLog;
    protected ArrayList outgoingMessageLog;
    protected int key;
    private boolean sendCompressed = false;
    private boolean gameMaster = false;
    protected GameEngine gameEngine;
    protected Color color = Color.white;

    public Player() {
        this.setId(Player.getIdCounter());
        Player.incrementIdCounter();
        this.Ships = new ArrayList();
        this.SpaceObjects = new ArrayList();
        this.incomingMessageLog = new ArrayList();
        this.outgoingMessageLog = new ArrayList();
        this.key = 0;
    }

    public GameEngine getGameEngine() {
        return this.gameEngine;
    }

    public void setGameEngine(GameEngine ge) {
        this.gameEngine = ge;
    }

    public ArrayList getShips() {
        return this.Ships;
    }

    public ArrayList getSpaceObjects() {
        return this.SpaceObjects;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public static int getIdCounter() {
        return idCounter;
    }

    public static void incrementIdCounter() {
        ++idCounter;
    }

    public void setEmail(String e) {
        this.email = e;
    }

    public String getEmail() {
        return this.email;
    }

    public void setTeam(String t) {
        this.team = t;
    }

    public String getTeam() {
        return this.team;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public int getKey() {
        return this.key;
    }

    public void setObjectives(String t) {
        this.objectives = t;
    }

    public String getObjectives() {
        return this.objectives;
    }

    public void setGameMaster(boolean tf) {
        this.gameMaster = tf;
    }

    public boolean isGameMaster() {
        return this.gameMaster;
    }

    public void setSendCompressed(boolean sc) {
        this.sendCompressed = sc;
    }

    public boolean getSendCompressed() {
        if (!this.gameMaster && this.gameEngine.getActivePlayer() == this) {
            String s = UserPreferences.getPreferences().getProperty("Receive Compressed Games");
            return s.equals("true");
        }
        return this.sendCompressed;
    }

    public String toString() {
        return this.getName();
    }

    public void setIncomingMessageLog(ArrayList a) {
        this.incomingMessageLog = a;
    }

    public ArrayList getIncomingMessageLog() {
        return this.incomingMessageLog;
    }

    public void setOutgoingMessageLog(ArrayList a) {
        this.outgoingMessageLog = a;
    }

    public ArrayList getOutgoingMessageLog() {
        return this.outgoingMessageLog;
    }

    public void clearIncomingMessageLog() {
        this.incomingMessageLog = new ArrayList();
    }

    public void clearOutgoingMessageLog() {
        this.outgoingMessageLog = new ArrayList();
    }

    public boolean hasMessages() {
        return this.incomingMessageLog.size() > 0;
    }

    public void addIncomingMessage(Message msg) {
        this.incomingMessageLog.add(msg);
    }

    public void addOutgoingMessage(Message msg) {
        this.outgoingMessageLog.add(msg);
    }

    public void removeShip(Ship s) {
        int index = this.Ships.indexOf(s);
        if (index != -1) {
            this.Ships.remove(index);
        }
    }

    public void addSpaceObject(SpaceObject so) {
        this.SpaceObjects.add(so);
    }

    public void removeSpaceObject(SpaceObject so) {
        int index = this.SpaceObjects.indexOf(so);
        if (index != -1) {
            this.SpaceObjects.remove(index);
        }
    }

    public boolean doesPlayerOwnShip(Ship s) {
        if (s == null) {
            return false;
        }
        int count = this.Ships.size();
        for (int i = 0; i < count; ++i) {
            Ship q = (Ship)this.Ships.get(i);
            if (q != s) continue;
            return true;
        }
        return false;
    }

    public boolean doesPlayerOwnShipId(int id) {
        if (id < 0) {
            return false;
        }
        int count = this.Ships.size();
        for (int i = 0; i < count; ++i) {
            Ship q = (Ship)this.Ships.get(i);
            int qid = q.getId();
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    public boolean doesPlayerOwnSpaceObjectId(int id) {
        if (id < 0) {
            return false;
        }
        int count = this.SpaceObjects.size();
        for (int i = 0; i < count; ++i) {
            SpaceObject q = (SpaceObject)this.SpaceObjects.get(i);
            int qid = q.getId();
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerDead() {
        int shipCount = this.Ships.size();
        for (int i = 0; i < shipCount; ++i) {
            Ship s = (Ship)this.Ships.get(i);
            if (s.isDestroyed() || s.hasJumped() || s.hasStruck()) continue;
            return false;
        }
        return true;
    }

    public boolean isPlayerRobot() {
        String n = this.getName();
        if (n.startsWith("Bot")) {
            return true;
        }
        if (n.startsWith("Robot")) {
            return true;
        }
        return n.startsWith("AI");
    }

    public String toXML(int level) {
        int i;
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        sb.append(t + "<Player id=\"" + this.getId() + "\"" + sep);
        sb.append(t + t + t + "name=\"" + this.getName() + "\"" + sep);
        sb.append(t + t + t + "email=\"" + this.getEmail() + "\"" + sep);
        if (this.isGameMaster()) {
            sb.append(t + t + t + "gameMaster=\"true\"" + sep);
        }
        sb.append(t + t + t + "team=\"" + this.getTeam());
        if (level <= 2) {
            sb.append("\" key=\"" + this.getKey() + "\">" + sep);
        } else {
            sb.append("\">" + sep);
        }
        sb.append(sep);
        if (level <= 2) {
            sb.append(this.objectivesToXML());
            sb.append(sep);
        }
        if (level <= 2) {
            sb.append(this.messagesToXML(this.incomingMessageLog));
            sb.append(sep);
        }
        int count = this.Ships.size();
        for (i = 0; i < count; ++i) {
            Ship a = (Ship)this.Ships.get(i);
            sb.append(a.toXML(level));
            sb.append(sep);
        }
        count = this.SpaceObjects.size();
        for (i = 0; i < count; ++i) {
            SpaceObject b = (SpaceObject)this.SpaceObjects.get(i);
            sb.append(b.toXML(level));
            sb.append(sep);
        }
        sb.append(t + "</Player>" + sep);
        sb.append(sep);
        return sb.toString();
    }

    public String toXML(ArrayList enemies) {
        int i;
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        int sensors = this.gameEngine.getOptions().getSensorRules();
        double rangeBand = this.gameEngine.getOptions().getSensorRangeBand();
        ArrayList hBodies = this.gameEngine.getHeavenlyBodies();
        sb.append(t + "<Player id=\"" + this.getId() + "\"" + sep);
        sb.append(t + t + t + "name=\"" + this.getName() + "\"" + sep);
        sb.append(t + t + t + "email=\"" + this.getEmail() + "\"" + sep);
        sb.append(t + t + t + "team=\"" + this.getTeam());
        sb.append("\">" + sep);
        sb.append(sep);
        ArrayList<SpaceObject> enemySpacecraft = new ArrayList<SpaceObject>();
        ArrayList<Missile> enemyNeedleMissiles = new ArrayList<Missile>();
        for (int i2 = 0; i2 < enemies.size(); ++i2) {
            int j;
            Player p = (Player)enemies.get(i2);
            for (j = 0; j < p.Ships.size(); ++j) {
                Ship s = (Ship)p.Ships.get(j);
                enemySpacecraft.add(s);
            }
            for (j = 0; j < p.SpaceObjects.size(); ++j) {
                Missile m;
                FighterGroup fGroup;
                SpaceObject so = (SpaceObject)p.SpaceObjects.get(j);
                if (so instanceof FighterGroup && (fGroup = (FighterGroup)so).getCount() != 0) {
                    enemySpacecraft.add(fGroup);
                }
                if (!(so instanceof Missile) || !(m = (Missile)so).getType().equals("Needle") || m.getTargetId() <= 0 || !this.gameEngine.isCombatPhase()) continue;
                enemyNeedleMissiles.add(m);
            }
        }
        int count = this.Ships.size();
        for (i = 0; i < count; ++i) {
            Ship a = (Ship)this.Ships.get(i);
            double range = a.minimumRangeTo(enemySpacecraft, hBodies) * a.getRangeStealthModifier();
            boolean written = false;
            for (int j = 0; j < enemyNeedleMissiles.size(); ++j) {
                Missile m = (Missile)enemyNeedleMissiles.get(j);
                if (m.getTargetId() != a.getId() || !m.canAttack(a, this.gameEngine.getOptions().getMissileLockOnRange())) continue;
                sb.append(a.toXML(4));
                written = true;
                break;
            }
            if (!written) {
                if (range <= rangeBand) {
                    sb.append(a.toXML(4));
                    written = true;
                } else if (range <= 2.0 * rangeBand) {
                    sb.append(a.toXML(5));
                    written = true;
                } else if (range <= 3.0 * rangeBand) {
                    sb.append(a.toXML(6));
                    written = true;
                } else if (range <= 4.0 * rangeBand) {
                    sb.append(a.toXML(7));
                    written = true;
                } else if (range <= 5.0 * rangeBand) {
                    sb.append(a.toXML(8));
                    written = true;
                }
            }
            if (sensors == 3) {
                boolean driveTest = false;
                if (a.getMainDrive() != null) {
                    boolean bl = driveTest = driveTest || a.getMainDrive().isActive();
                }
                if (a.getFTLDrive() != null) {
                    boolean bl = driveTest = driveTest || a.getFTLDrive().isActive();
                }
                if (!written && driveTest && range >= 5.0 * rangeBand && range <= this.gameEngine.getOptions().getSensorBlipBands() * rangeBand) {
                    sb.append(a.toXML(9));
                }
            }
            sb.append(sep);
        }
        count = this.SpaceObjects.size();
        for (i = 0; i < count; ++i) {
            SpaceObject b = (SpaceObject)this.SpaceObjects.get(i);
            double range = b.minimumRangeTo(enemySpacecraft, hBodies) * b.getRangeStealthModifier();
            if (b instanceof HeavenlyBody) {
                sb.append(((HeavenlyBody)b).toXML(4));
            }
            if (b instanceof WaveGunBolt) {
                sb.append(((WaveGunBolt)b).toXML(4));
            }
            if (b instanceof NovaCannonBolt) {
                sb.append(((NovaCannonBolt)b).toXML(4));
            }
            if (range <= 5.0 * rangeBand) {
                if (b instanceof AntiMatterTorpedo) {
                    sb.append(((AntiMatterTorpedo)b).toXML(4));
                }
                if (b instanceof FighterGroup) {
                    sb.append(((FighterGroup)b).toXML(4));
                }
                if (b instanceof MissileSalvo) {
                    sb.append(((MissileSalvo)b).toXML(4));
                }
                if (b instanceof PlasmaBolt) {
                    PlasmaBolt pb = (PlasmaBolt)b;
                    sb.append(pb.toXML(4));
                }
                if (b instanceof Missile) {
                    sb.append(((Missile)b).toXML(4));
                }
            }
            sb.append(sep);
        }
        sb.append(t + "</Player>" + sep);
        sb.append(sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        int i;
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        sb.append(t + "<PlayerOrders id=\"" + this.getId());
        sb.append("\" name=\"" + this.getName());
        sb.append("\" email=\"" + this.getEmail());
        sb.append("\" compress=\"" + this.getSendCompressed());
        sb.append("\" team=\"" + this.getTeam());
        sb.append("\" key=\"" + this.getKey() + "\">" + sep);
        sb.append(this.messagesToXML(this.outgoingMessageLog));
        int count = this.Ships.size();
        for (i = 0; i < count; ++i) {
            Ship a = (Ship)this.Ships.get(i);
            sb.append(a.movementOrdersToXML());
        }
        count = this.SpaceObjects.size();
        for (i = 0; i < count; ++i) {
            SpaceObject b = (SpaceObject)this.SpaceObjects.get(i);
            if (b instanceof MissileSalvo) {
                MissileSalvo ms = (MissileSalvo)b;
                sb.append(ms.movementOrdersToXML());
            }
            if (b instanceof PlasmaBolt) {
                PlasmaBolt pb = (PlasmaBolt)b;
                sb.append(pb.movementOrdersToXML());
            }
            if (b instanceof NovaCannonBolt) {
                NovaCannonBolt ncb = (NovaCannonBolt)b;
                sb.append(ncb.movementOrdersToXML());
            }
            if (b instanceof WaveGunBolt) {
                WaveGunBolt wgb = (WaveGunBolt)b;
                sb.append(wgb.movementOrdersToXML());
            }
            if (b instanceof AntiMatterTorpedo) {
                AntiMatterTorpedo amt = (AntiMatterTorpedo)b;
                sb.append(amt.movementOrdersToXML());
            }
            if (b instanceof FighterGroup) {
                sb.append(((FighterGroup)b).movementOrdersToXML());
            }
            if (!(b instanceof Missile)) continue;
            sb.append(((Missile)b).movementOrdersToXML());
        }
        sb.append(t + "</PlayerOrders>" + sep);
        return sb.toString();
    }

    public String combatOrdersToXML() {
        int i;
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        sb.append(t + "<PlayerOrders id=\"" + this.getId());
        sb.append("\" name=\"" + this.getName());
        sb.append("\" email=\"" + this.getEmail());
        sb.append("\" compress=\"" + this.getSendCompressed());
        sb.append("\" team=\"" + this.getTeam());
        sb.append("\" key=\"" + this.getKey() + "\">" + sep);
        sb.append(this.messagesToXML(this.outgoingMessageLog));
        int count = this.Ships.size();
        for (i = 0; i < count; ++i) {
            Ship a = (Ship)this.Ships.get(i);
            sb.append(a.combatOrdersToXML());
        }
        count = this.SpaceObjects.size();
        for (i = 0; i < count; ++i) {
            SpaceObject b = (SpaceObject)this.SpaceObjects.get(i);
            if (b instanceof FighterGroup) {
                sb.append(((FighterGroup)b).combatOrdersToXML());
            }
            if (!(b instanceof Missile)) continue;
            sb.append(((Missile)b).combatOrdersToXML());
        }
        sb.append(t + "</PlayerOrders>" + sep);
        return sb.toString();
    }

    private String objectivesToXML() {
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String obj = XMLUtilities.wrapSpecialCharsXML(this.getObjectives());
        sb.append("        <Objectives>" + obj + "</Objectives>" + sep);
        return sb.toString();
    }

    private String messagesToXML(ArrayList a) {
        String sep = System.getProperty("line.separator");
        if (a.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("        <Messages>" + sep);
        for (int i = 0; i < a.size(); ++i) {
            Object o = a.get(i);
            if (!(o instanceof Message)) {
                throw new IllegalArgumentException("Not a message!");
            }
            sb.append(((Message)o).toXML(3));
        }
        sb.append("        </Messages>" + sep);
        return sb.toString();
    }
}

