/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Message;
import ftjava.std.Player;
import java.util.ArrayList;

public class PostOffice {
    private ArrayList thePlayers;
    public static final String ALL_PLAYERS = "All Players";

    public PostOffice(ArrayList p) {
        this.thePlayers = p;
    }

    public void execute() {
        Player p;
        int i;
        if (this.thePlayers.size() == 0) {
            return;
        }
        int count = 0;
        for (i = 0; i < this.thePlayers.size(); ++i) {
            p = (Player)this.thePlayers.get(i);
            count += p.getOutgoingMessageLog().size();
            p.clearIncomingMessageLog();
        }
        if (count == 0) {
            return;
        }
        for (i = 0; i < this.thePlayers.size(); ++i) {
            p = (Player)this.thePlayers.get(i);
            ArrayList msgList = p.getOutgoingMessageLog();
            for (int j = 0; j < msgList.size(); ++j) {
                Message theMessage = (Message)msgList.get(j);
                String sendTo = theMessage.getTo();
                if (sendTo.equals(ALL_PLAYERS)) {
                    this.sendToAllPlayers(theMessage);
                }
                if (this.isaTeam(sendTo)) {
                    this.sendToTeam(sendTo, theMessage);
                    continue;
                }
                this.sendToPlayer(sendTo, theMessage);
            }
            p.clearOutgoingMessageLog();
        }
    }

    private void sendToAllPlayers(Message m) {
        for (int i = 0; i < this.thePlayers.size(); ++i) {
            Player p = (Player)this.thePlayers.get(i);
            p.addIncomingMessage(m);
        }
    }

    private void sendToTeam(String team, Message m) {
        for (int i = 0; i < this.thePlayers.size(); ++i) {
            Player p = (Player)this.thePlayers.get(i);
            if (!p.getTeam().equals(team)) continue;
            p.addIncomingMessage(m);
        }
    }

    private void sendToPlayer(String player, Message m) {
        for (int i = 0; i < this.thePlayers.size(); ++i) {
            Player p = (Player)this.thePlayers.get(i);
            if (!p.getName().equals(player)) continue;
            p.addIncomingMessage(m);
        }
    }

    private boolean isaTeam(String team) {
        for (int i = 0; i < this.thePlayers.size(); ++i) {
            Player p = (Player)this.thePlayers.get(i);
            if (!p.getTeam().equals(team)) continue;
            return true;
        }
        return false;
    }
}

