/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class Pulser
extends Weapon {
    public static final char CLOSE_RANGE = 'C';
    public static final char MEDIUM_RANGE = 'M';
    public static final char LONG_RANGE = 'L';
    public static final char UNTUNED = '-';
    private char rangeMode;

    public Pulser() {
        this(Weapon.FORE_ARC, '-');
    }

    public Pulser(int arcs) {
        this(arcs, 'M');
    }

    public Pulser(String arcs) {
        this(Weapon.parseArcString(arcs), '-');
    }

    public Pulser(String arcs, String mode) {
        this(Weapon.parseArcString(arcs), mode.charAt(0));
    }

    public Pulser(int arcs, char mode) {
        this.setArcs(arcs);
        this.setRangeMode(mode);
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setSystemName("Pulser-" + this.rangeMode + " " + this.getArcsString());
    }

    public char getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(char mode) {
        double rangeBand = this.getOptions().getPulserRangeBand();
        switch (mode) {
            case 'C': {
                this.rangeMode = mode;
                this.setMaximumRange(rangeBand);
                return;
            }
            case 'M': {
                this.rangeMode = mode;
                this.setMaximumRange(2.0 * rangeBand);
                return;
            }
            case 'L': {
                this.rangeMode = mode;
                this.setMaximumRange(3.0 * rangeBand);
                return;
            }
            case '-': {
                this.rangeMode = mode;
                this.setMaximumRange(0.0);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setValue(String name, String value) {
        if (name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(value));
        } else if (name.equals("mode")) {
            this.setRangeMode(value.charAt(0));
        } else if (name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(value));
        } else {
            super.setValue(name, value);
        }
        this.setSystemName("Pulser-" + this.rangeMode + " " + this.getArcsString());
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        boolean pdsMode = false;
        if (target instanceof MissileSalvo || target instanceof PlasmaBolt || target instanceof Missile || target instanceof AntiMatterTorpedo || target instanceof FighterGroup) {
            pdsMode = true;
        }
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!pdsMode && !(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        if (pdsMode) {
            this.fireAtPointDefense(firer, target);
        } else {
            this.fireAtDirectFire(firer, target);
        }
    }

    private void fireAtDirectFire(SpaceObject firer, SpaceObject target) {
        String record;
        double pulserRange;
        DecimalFormat df = new DecimalFormat("0.0");
        int[] damage = new int[1];
        int numDice = 0;
        int die = 0;
        int totalDamage = 0;
        int screens = 0;
        int rerolls = 0;
        int penetration = 0;
        Ship s = (Ship)target;
        screens = s.getNumberOfActiveScreens();
        double targetRange = firer.rangeTo(target) * target.getRangeStealthModifier();
        switch (this.rangeMode) {
            case 'C': {
                pulserRange = this.getOptions().getPulserRangeBand();
                numDice = 6;
                break;
            }
            case 'M': {
                pulserRange = 2.0 * this.getOptions().getPulserRangeBand();
                numDice = 2;
                break;
            }
            case 'L': {
                pulserRange = 3.0 * this.getOptions().getPulserRangeBand();
                numDice = 1;
                break;
            }
            default: {
                pulserRange = 0.0;
                numDice = 0;
            }
        }
        this.setFired();
        boolean hit = false;
        boolean deflected = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(targetRange) + " ";
        String targetName = target.getName();
        if (targetRange > pulserRange) {
            numDice = 0;
        }
        while (numDice > 0) {
            block12: for (int i = 0; i < numDice; ++i) {
                die = Dice.rollD6(firer.getCrewQuality());
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        continue block12;
                    }
                    case 4: {
                        if (screens == 0) {
                            int n = penetration;
                            damage[n] = damage[n] + 1;
                            hit = true;
                            continue block12;
                        }
                        deflected = true;
                        continue block12;
                    }
                    case 5: {
                        hit = true;
                        int n = penetration;
                        damage[n] = damage[n] + 1;
                        continue block12;
                    }
                    case 6: {
                        hit = true;
                        if (screens == 2) {
                            int n = penetration;
                            damage[n] = damage[n] + 1;
                        } else {
                            int n = penetration;
                            damage[n] = damage[n] + 2;
                        }
                        if (!this.getOptions().getPenetratingDamage()) continue block12;
                        ++rerolls;
                    }
                }
            }
            if (rerolls > 0) {
                numDice = rerolls;
                rerolls = 0;
                screens = 0;
                int[] temp = new int[++penetration + 1];
                System.arraycopy(damage, 0, temp, 0, damage.length);
                damage = temp;
                continue;
            }
            numDice = 0;
        }
        if (!hit) {
            String record2;
            if (deflected) {
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Deflected by " + targetName + "'s shielding. " + playTestResults);
                    record2 = firer.getName() + " hit, but deflected with a pulser-" + this.getRangeMode() + playTestResults;
                } else {
                    this.setNotes("Deflected by " + targetName + "'s shielding.");
                    record2 = firer.getName() + " hit, but deflected with a pulser-" + this.getRangeMode();
                }
            } else if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a pulser-" + this.getRangeMode() + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a pulser-" + this.getRangeMode() + ".";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        for (int i = 0; i < damage.length; ++i) {
            totalDamage += damage[i];
        }
        if (this.getOptions().getPlayTest()) {
            String str = "Hit the " + targetName + " for ";
            str = str + StringUtils.points(totalDamage) + ".";
            this.setNotes(str + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a pulser-" + this.getRangeMode() + " . " + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a pulser-" + this.getRangeMode() + " .";
        }
        target.addLog("Attack", "High", record);
        s.takeDamage(damage);
    }

    private void fireAtPointDefense(SpaceObject firer, SpaceObject target) {
        FighterGroup fg;
        DecimalFormat df = new DecimalFormat("0.0");
        int kills = 0;
        int plasmaHits = 0;
        int rerolls = 0;
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        int dice = 1;
        if (range > 0.5 * this.getOptions().getPulserRangeBand()) {
            dice = 0;
        }
        this.setFired();
        boolean hit = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        boolean isHeavyFighter = false;
        if (target instanceof FighterGroup && (fg = (FighterGroup)target).getType().isAHeavyFighter()) {
            isHeavyFighter = true;
        }
        while (dice > 0) {
            block7: for (int i = 0; i < dice; ++i) {
                int die = Dice.rollD6(firer.getCrewQuality());
                String rerollChar = hit ? "*" : "";
                playTestResults = playTestResults + "(" + die + rerollChar + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: {
                        continue block7;
                    }
                    case 4: {
                        if (isHeavyFighter) continue block7;
                    }
                    case 5: {
                        hit = true;
                        ++kills;
                        continue block7;
                    }
                    case 6: {
                        hit = true;
                        kills += 2;
                        plasmaHits = 1;
                        ++rerolls;
                    }
                }
            }
            dice = 0;
            if (!this.getOptions().getPenetratingDamage()) continue;
            dice = rerolls;
            rerolls = 0;
        }
        String targetName = target.getName();
        if ((target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) && plasmaHits == 0) {
            hit = false;
        }
        if (!hit) {
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed " + targetName + ". " + playTestResults);
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed" + " with a pulser. " + playTestResults);
                }
            } else {
                this.setNotes("Missed " + targetName + ".");
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed" + " with a pulser. ");
                }
            }
            return;
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            this.setNotes("Hit " + targetName + " for " + StringUtils.points(plasmaHits) + ".");
        } else {
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(kills) + ".");
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(kills) + " with a Pulser. ");
            }
        }
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (target instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)target;
            ms.takeDamage(new int[]{kills});
        }
        if (target instanceof FighterGroup) {
            FighterGroup fg2 = (FighterGroup)target;
            fg2.takeDamage(new int[]{kills});
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            target.takeDamage(new int[]{plasmaHits});
        }
    }

    public int computeMass() {
        int numArcs = this.computeNumberOfArcs();
        if (numArcs > 3 && numArcs <= 6) {
            return 4;
        }
        if (numArcs <= 3 && numArcs > 1) {
            return 3;
        }
        return 2;
    }

    public int computePointCost() {
        return 5 * this.computeMass();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        result.append("   ");
        result.append(this.getSystemName());
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result.append(" ");
            }
            result.append(this.getSystemStatus());
        }
        return result.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer result = new StringBuffer(512);
        String t = XMLUtilities.getIndent();
        if (level >= 6) {
            return result.toString();
        }
        result.append(t).append(t);
        result.append("<Pulser");
        if (level > 0) {
            result.append(" id=\"").append(this.getId()).append("\"");
        }
        if (this.isSSDDefined()) {
            result.append(" xSSD=\"").append(this.getXSSD()).append("\"");
            result.append(" ySSD=\"").append(this.getYSSD()).append("\"");
        }
        result.append(" arcs=\"").append(this.getArcsString()).append("\"");
        result.append(" mode=\"").append(this.getRangeMode()).append("\"");
        if (this.getTargetId() != 0 && (level == 2 || level == 1)) {
            result.append(" targetId=\"" + this.getTargetId() + "\"");
        }
        if (level != 0 && level != 5) {
            result.append(" status=\"").append(this.getSystemStatus()).append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            result.append(" notes=\"").append(this.getNotes()).append("\"");
        }
        result.append("/>");
        result.append(System.getProperty("line.separator"));
        return result.toString();
    }

    static {
        Weapon.addSystem("Pulser", new Pulser());
    }
}

