/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;
import java.util.ArrayList;

public class SalvoMissileMagazine
extends Weapon {
    public static final String STANDARD_SALVO = "Standard Salvo";
    public static final String EXTENDED_RANGE_SALVO = "Extended Range Salvo";
    public static final String AVAILABLE = "Available";
    private int capacity;
    private ArrayList salvos = null;
    private ArrayList salvoStatus = null;
    private int maximumInRow = 4;

    public SalvoMissileMagazine() {
        this(4);
    }

    public SalvoMissileMagazine(int a) {
        this.setArcs(0);
        this.capacity = a;
        this.setSystemName("Salvo Missile Magazine (" + this.capacity + ")");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("capacity")) {
            this.salvos = null;
            this.salvoStatus = null;
            this.setCapacity(Integer.parseInt(Value));
            handled = true;
        }
        if (Name.equals("maxInRow")) {
            this.setMaximumInRow(Integer.parseInt(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void setCapacity(int c) {
        this.capacity = c;
        this.setSystemName("Salvo Missile Magazine (" + this.capacity + ")");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setMaximumInRow(int i) {
        this.maximumInRow = i;
    }

    public int getMaximumInRow() {
        return this.maximumInRow;
    }

    public int getSalvoCount() {
        if (this.salvos == null) {
            return 0;
        }
        return this.salvos.size();
    }

    public ArrayList getSalvos() {
        return this.salvos;
    }

    public ArrayList getSalvoStatus() {
        return this.salvoStatus;
    }

    public int getSalvoCount(String type) {
        return this.getSalvoCount(type, AVAILABLE) + this.getSalvoCount(type, "Expended");
    }

    public int getSalvoCount(String type, String status) {
        int count = 0;
        if (this.salvos == null) {
            return 0;
        }
        for (int i = 0; i < this.salvos.size(); ++i) {
            String t = (String)this.salvos.get(i);
            String s = (String)this.salvoStatus.get(i);
            if (!t.equals(type) || !s.equals(status)) continue;
            ++count;
        }
        return count;
    }

    public void fillMagazine(int c) {
        if (c <= 0) {
            return;
        }
        if (c > this.capacity) {
            return;
        }
        this.salvos = new ArrayList();
        this.salvoStatus = new ArrayList();
        int remainder = c;
        while (remainder > 1) {
            if (remainder % 2 == 1) {
                this.addSalvo(EXTENDED_RANGE_SALVO, AVAILABLE);
                remainder -= 3;
                continue;
            }
            this.addSalvo(STANDARD_SALVO, AVAILABLE);
            remainder -= 2;
        }
    }

    public void fillMagazine(int s, int er) {
        int j;
        this.salvos = new ArrayList();
        this.salvoStatus = new ArrayList();
        int size = 2 * s + 3 * er;
        if (size > this.capacity) {
            return;
        }
        for (j = 0; j < s; ++j) {
            this.addSalvo(STANDARD_SALVO, AVAILABLE);
        }
        for (j = 0; j < er; ++j) {
            this.addSalvo(EXTENDED_RANGE_SALVO, AVAILABLE);
        }
    }

    public void addSalvo(String type, String status) {
        if (this.salvos == null) {
            this.salvos = new ArrayList();
            this.salvoStatus = new ArrayList();
        }
        this.salvos.add(type);
        this.salvoStatus.add(status);
    }

    public void removeSalvo(String type, String status) {
        if (this.salvos != null) {
            for (int i = 0; i < this.salvos.size(); ++i) {
                String t = (String)this.salvos.get(i);
                String s = (String)this.salvoStatus.get(i);
                if (!t.equals(type) || !s.equals(status)) continue;
                this.salvos.remove(i);
                this.salvoStatus.remove(i);
                return;
            }
        }
    }

    public boolean expendOne(double range) {
        if (range <= this.getOptions().getSalvoMissileRange() && this.expendOne(STANDARD_SALVO)) {
            return true;
        }
        return range <= this.getOptions().getSalvoMissileExtendedRange() && this.expendOne(EXTENDED_RANGE_SALVO);
    }

    public boolean expendOne(String salvoType) {
        if (!this.getSystemStatus().equals("Operational")) {
            return false;
        }
        for (int i = 0; i < this.salvos.size(); ++i) {
            String type = (String)this.salvos.get(i);
            String status = (String)this.salvoStatus.get(i);
            if (!type.equals(salvoType) || !status.equals(AVAILABLE)) continue;
            this.salvoStatus.set(i, "Expended");
            return true;
        }
        return false;
    }

    public boolean isOneAvailable(String salvoType) {
        if (!this.getSystemStatus().equals("Operational")) {
            return false;
        }
        for (int i = 0; i < this.getSalvoCount(); ++i) {
            String type = (String)this.salvos.get(i);
            String status = (String)this.salvoStatus.get(i);
            if (!type.equals(salvoType) || !status.equals(AVAILABLE)) continue;
            return true;
        }
        return false;
    }

    public boolean isOneAvailable() {
        boolean t1 = this.isOneAvailable(STANDARD_SALVO);
        boolean t2 = this.isOneAvailable(EXTENDED_RANGE_SALVO);
        return t1 || t2;
    }

    public boolean isOneAvailable(double range) {
        if (range <= this.getOptions().getSalvoMissileRange() && this.isOneAvailable(STANDARD_SALVO)) {
            return true;
        }
        return range <= this.getOptions().getSalvoMissileExtendedRange() && this.isOneAvailable(EXTENDED_RANGE_SALVO);
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public int computeMass() {
        return this.capacity;
    }

    public int computePointCost() {
        return this.capacity * 3;
    }

    public String toString() {
        String line = "";
        String padding = "   ";
        String result = "";
        String newLine = System.getProperty("line.separator");
        line = line + padding + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (line.length() < this.getOptions().getStatusSpacing()) {
                line = line + " ";
            }
            line = line + this.getSystemStatus();
        }
        result = result + line + newLine;
        for (int i = 0; i < this.getSalvoCount(); ++i) {
            line = padding + padding + this.salvos.get(i);
            while (line.length() < this.getOptions().getStatusSpacing()) {
                line = line + " ";
            }
            line = line + this.salvoStatus.get(i);
            result = i != this.salvos.size() - 1 ? result + line + newLine : result + line;
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<SalvoMissileMagazine");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" maxInRow=\"" + this.getMaximumInRow() + "\"");
        sb.append(" capacity=\"" + this.getCapacity() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append(">");
        sb.append(sep);
        for (int i = 0; i < this.getSalvoCount(); ++i) {
            String type = (String)this.salvos.get(i);
            String status = (String)this.salvoStatus.get(i);
            sb.append(t + t + t + t + t + "<Salvo type=\"");
            sb.append(type + "\" ");
            sb.append("status=\"" + status + "\"/>");
            sb.append(sep);
        }
        sb.append(t + t + t + t + "</SalvoMissileMagazine>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("SalvoMissileMagazine", new SalvoMissileMagazine());
    }
}

