/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.MissileSalvo;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class SalvoMissileRack
extends Weapon {
    private String type;

    public SalvoMissileRack() {
        this(Weapon.FRONT_ARCS);
    }

    public SalvoMissileRack(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public SalvoMissileRack(int a) {
        this.setArcs(a);
        this.setSystemName("Salvo Missile Rack      " + this.getArcsString());
        this.setType("Standard Salvo");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public SalvoMissileRack(String t, int a) {
        this.setType(t);
        this.setArcs(a);
        if (this.type.equals("Extended Range Salvo")) {
            this.setSystemName("Salvo Missile Rack (ER) " + this.getArcsString());
        } else {
            this.setSystemName("Salvo Missile Rack      " + this.getArcsString());
        }
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Salvo Missile Rack " + this.getArcsString());
        } else if (Name.equals("type")) {
            this.setType(Value);
        } else {
            super.setValue(Name, Value);
        }
    }

    public void setType(String t) {
        if (t.equals("Extended Range Salvo")) {
            this.type = "Extended Range Salvo";
            this.setSystemName("Salvo Missile Rack (ER) " + this.getArcsString());
        } else {
            this.type = "Standard Salvo";
            this.setSystemName("Salvo Missile Rack      " + this.getArcsString());
        }
    }

    public String getType() {
        return this.type;
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, MissileSalvo ms) {
        if (!this.getSystemStatus().equals("Operational")) {
            this.setNotes("Weapon is not operational.");
            return false;
        }
        if (this.hasFired()) {
            this.setNotes("Weapon has fired already!");
            return false;
        }
        double range = firer.rangeTo(ms);
        if (range > this.getOptions().getSalvoMissileExtendedRange()) {
            this.setNotes("Launch point is out of extended range.");
            return false;
        }
        if (range > this.getOptions().getSalvoMissileRange() && ms.getSalvoType().equals("Standard Salvo")) {
            this.setNotes("Launch point is out of range.");
            return false;
        }
        if (!this.fireAtTargetArc(firer.arcTo(ms))) {
            this.setNotes("Launch point is out of arc.");
            return false;
        }
        return true;
    }

    public void fireSalvo(SpaceObject firer, MissileSalvo ms) {
        this.setFired();
        this.setExpended();
    }

    public int computeMass() {
        int mass = 4;
        if (this.type.equals("Extended Range Salvo")) {
            mass = 5;
        }
        return mass;
    }

    public int computePointCost() {
        return 3 * this.computeMass();
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<SalvoMissileRack");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" type=\"" + this.getType() + "\"");
        sb.append(" arcs=\"" + this.getArcsString() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("SalvoMissileRack", new SalvoMissileRack());
    }
}

