/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FireControl;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import java.util.HashMap;

public abstract class Weapon
extends ShipSystem
implements Cloneable {
    private int arcs;
    private boolean fired;
    private int fireRate = 1;
    private int recharge = 0;
    private SpaceObject target;
    private int targetId;
    private FireControl firecontrol;
    private int fireType = DIRECT_FIRE;
    private double maximumRange;
    private static HashMap WeaponMap = new HashMap();
    public static int ARCS_SHIFT = 21;
    public static int AFT_ARC = 1 << ARCS_SHIFT;
    public static int AFT_STARBOARD_ARC = 2 << ARCS_SHIFT;
    public static int FORE_STARBOARD_ARC = 4 << ARCS_SHIFT;
    public static int FORE_ARC = 8 << ARCS_SHIFT;
    public static int FORE_PORT_ARC = 16 << ARCS_SHIFT;
    public static int AFT_PORT_ARC = 32 << ARCS_SHIFT;
    public static int ALL_ARCS = 63 << ARCS_SHIFT;
    public static int FRONT_ARCS = 28 << ARCS_SHIFT;
    public static int AFT_ARCS = 35 << ARCS_SHIFT;
    public static int PORT_ARCS = 56 << ARCS_SHIFT;
    public static int STARBOARD_ARCS = 14 << ARCS_SHIFT;
    public static int STARBOARD_BROADSIDE_ARCS = 6 << ARCS_SHIFT;
    public static int PORT_BROADSIDE_ARCS = 48 << ARCS_SHIFT;
    public static int DIRECT_FIRE = 0;
    public static int LAUNCHED_FIRE = 1;
    public static int POINT_DEFENSE = 2;

    public Weapon() {
        this(ALL_ARCS);
    }

    public Weapon(int a) {
        this.setSystemName("Unknown weapon");
        this.arcs = a;
        this.target = null;
        this.targetId = 0;
        this.fireType = DIRECT_FIRE;
        this.maximumRange = 3.0 * this.getOptions().getBeamRangeBand();
    }

    public static void addSystem(String Name, Weapon instance) {
        WeaponMap.put(Name, instance);
    }

    public static Weapon findSystem(String Name) {
        Weapon w = null;
        if (WeaponMap.containsKey(Name)) {
            try {
                w = (Weapon)((Weapon)WeaponMap.get(Name)).clone();
            }
            catch (Exception e) {
                return null;
            }
        }
        ShipSystem newWeapon = Weapon.deepSearchByName(Name);
        if (newWeapon == null) {
            return null;
        }
        if (!(newWeapon instanceof Weapon)) {
            return null;
        }
        WeaponMap.put(Name, newWeapon);
        try {
            w = (Weapon)((Weapon)newWeapon).clone();
        }
        catch (Exception e) {
            return null;
        }
        w.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        return w;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("arcs")) {
            this.arcs = Weapon.parseArcString(Value);
            handled = true;
        }
        if (Name.equals("recharge")) {
            this.setRecharge(Integer.valueOf(Value));
            handled = true;
        }
        if (Name.equals("firerate")) {
            this.setFireRate(Integer.valueOf(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
        if (t != null) {
            this.setTargetId(t.getId());
        } else {
            this.setTargetId(0);
        }
    }

    public SpaceObject getTarget() {
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setArcs(int a) {
        if (!this.getOptions().getAftArcFire() && a == AFT_ARC) {
            a = FORE_ARC;
        }
        this.arcs = a;
    }

    public int getArcs() {
        return this.arcs;
    }

    public void setMaximumRange(double range) {
        this.maximumRange = range;
    }

    public double getMaximumRange() {
        return this.maximumRange;
    }

    public boolean hasFired() {
        return this.fired;
    }

    public void setFired() {
        this.fired = true;
        this.recharge = this.fireRate;
    }

    public void resetFired() {
        this.fired = false;
        if (this.recharge > 0) {
            --this.recharge;
        }
    }

    public void setFireRate(int i) {
        this.fireRate = i;
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public void setRecharge(int i) {
        this.recharge = i;
    }

    public int getRecharge() {
        return this.recharge;
    }

    public boolean isRecharged() {
        return this.recharge == 0;
    }

    public void setMasterFireControl(FireControl fc) {
        this.firecontrol = fc;
    }

    public FireControl getMasterFireControl() {
        return this.firecontrol;
    }

    public void setFireTypeDirect() {
        this.fireType = DIRECT_FIRE;
    }

    public void setFireTypeLaunched() {
        this.fireType = LAUNCHED_FIRE;
    }

    public void setFireTypePointDefense() {
        this.fireType = POINT_DEFENSE;
    }

    public boolean isDirectFire() {
        return this.fireType == DIRECT_FIRE;
    }

    public boolean isLaunchedFire() {
        return this.fireType == LAUNCHED_FIRE;
    }

    public boolean isPointDefense() {
        return this.fireType == POINT_DEFENSE;
    }

    public abstract void fireAt(SpaceObject var1, SpaceObject var2);

    public boolean fireAftArc() {
        if (!this.getOptions().getAftArcFire()) {
            return false;
        }
        return (this.arcs & AFT_ARC) == AFT_ARC;
    }

    public boolean fireAftStarboardArc() {
        return (this.arcs & AFT_STARBOARD_ARC) == AFT_STARBOARD_ARC;
    }

    public boolean fireForeStarboardArc() {
        return (this.arcs & FORE_STARBOARD_ARC) == FORE_STARBOARD_ARC;
    }

    public boolean fireForeArc() {
        return (this.arcs & FORE_ARC) == FORE_ARC;
    }

    public boolean fireForePortArc() {
        return (this.arcs & FORE_PORT_ARC) == FORE_PORT_ARC;
    }

    public boolean fireAftPortArc() {
        return (this.arcs & AFT_PORT_ARC) == AFT_PORT_ARC;
    }

    public boolean fireAllArcs() {
        return (this.arcs & ALL_ARCS) == ALL_ARCS;
    }

    public boolean fireAftArcs() {
        return (this.arcs & AFT_ARCS) == AFT_ARCS;
    }

    public boolean fireAtTargetArc(int targetArc) {
        if (!this.getOptions().getAftArcFire() && targetArc == AFT_ARC) {
            return false;
        }
        return (this.arcs & targetArc) == targetArc;
    }

    public String getArcsString() {
        String result = "(";
        boolean first = true;
        if (this.fireAllArcs()) {
            return "(All arcs)";
        }
        if (this.fireAftArcs()) {
            return "(AP/A/AS)";
        }
        if (this.fireAftPortArc()) {
            result = result + "AP";
            first = false;
        }
        if (this.fireForePortArc()) {
            if (!first) {
                result = result + "/";
            }
            result = result + "FP";
            first = false;
        }
        if (this.fireForeArc()) {
            if (!first) {
                result = result + "/";
            }
            result = result + "F";
            first = false;
        }
        if (this.fireForeStarboardArc()) {
            if (!first) {
                result = result + "/";
            }
            result = result + "FS";
            first = false;
        }
        if (this.fireAftStarboardArc()) {
            if (!first) {
                result = result + "/";
            }
            result = result + "AS";
            first = false;
        }
        if (this.fireAftArc()) {
            if (!first) {
                result = result + "/";
            }
            result = result + "A";
            first = false;
        }
        result = result + ")";
        return result;
    }

    public static int parseArcString(String a) {
        int arcs = 0;
        if (a.length() == 0) {
            return arcs;
        }
        String p = a.replace('(', ' ');
        p = p.replace(')', ' ');
        p = p.replace('/', ' ');
        if ((p = p.toUpperCase()).indexOf(" F ") >= 0) {
            arcs |= FORE_ARC;
        }
        if (p.indexOf(" FP ") >= 0) {
            arcs |= FORE_PORT_ARC;
        }
        if (p.indexOf(" FS ") >= 0) {
            arcs |= FORE_STARBOARD_ARC;
        }
        if (p.indexOf(" A ") >= 0) {
            arcs |= AFT_ARC;
        }
        if (p.indexOf(" AP ") >= 0) {
            arcs |= AFT_PORT_ARC;
        }
        if (p.indexOf(" AS ") >= 0) {
            arcs |= AFT_STARBOARD_ARC;
        }
        if (p.indexOf(" ALL ") >= 0) {
            arcs |= ALL_ARCS;
        }
        if (arcs == 0) {
            arcs |= FORE_ARC;
        }
        return arcs;
    }

    public int computeNumberOfArcs() {
        int count = 0;
        if (this.fireForeArc()) {
            ++count;
        }
        if (this.fireForePortArc()) {
            ++count;
        }
        if (this.fireForeStarboardArc()) {
            ++count;
        }
        if (this.fireAftArc()) {
            ++count;
        }
        if (this.fireAftPortArc()) {
            ++count;
        }
        if (this.fireAftStarboardArc()) {
            ++count;
        }
        return count;
    }
}

