/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.Message;
import ftjava.util.XMLUtilities;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportMessages {
    public static ArrayList parseMessages(Node node) {
        ArrayList<Message> messages = new ArrayList<Message>();
        NodeList children = node.getChildNodes();
        if (children == null) {
            return messages;
        }
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!name.equals("Message")) continue;
            Message msg = new Message();
            if (XMLUtilities.attributeExists(child, "to")) {
                String tName = XMLUtilities.getAttribute(child, "to");
                msg.setTo(tName);
            }
            if (XMLUtilities.attributeExists(child, "from")) {
                String fName = XMLUtilities.getAttribute(child, "from");
                msg.setFrom(fName);
            }
            if (XMLUtilities.attributeExists(child, "priority")) {
                String prior = XMLUtilities.getAttribute(child, "priority");
                msg.setPriority(prior);
            }
            if (XMLUtilities.attributeExists(child, "turn")) {
                int turnNumber = (int)XMLUtilities.getNumericAttribute(child, "turn");
                msg.setTurn(turnNumber);
            }
            msg.setMessage(child.getFirstChild().getNodeValue().trim());
            messages.add(msg);
        }
        return messages;
    }
}

