/*
 * Decompiled with CFR 0.152.
 */
package uk.org.skeet.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import uk.org.skeet.util.Semaphore;

public class Graphics2DUtil {
    public static final int POSITION_CENTRE = -1;
    public static final int POSITION_N = 0;
    public static final int POSITION_NE = 1;
    public static final int POSITION_E = 2;
    public static final int POSITION_SE = 3;
    public static final int POSITION_S = 4;
    public static final int POSITION_SW = 5;
    public static final int POSITION_W = 6;
    public static final int POSITION_NW = 7;
    Graphics2D graphics;
    FontRenderContext frc;

    public Graphics2DUtil(Graphics2D graphics) {
        this.graphics = graphics;
        this.frc = graphics.getFontRenderContext();
    }

    public void fillCircle(Point p, int radius) {
        Ellipse2D.Float oval = new Ellipse2D.Float((float)(p.x - radius) + 0.5f, (float)(p.y - radius) + 0.5f, radius * 2, radius * 2);
        this.graphics.fill(oval);
    }

    public void drawCircle(Point p, int radius) {
        Ellipse2D.Float oval = new Ellipse2D.Float((float)(p.x - radius) + 0.5f, (float)(p.y - radius) + 0.5f, radius * 2, radius * 2);
        this.graphics.draw(oval);
    }

    public void drawArc(Point p, int radius, int cornerNo) {
        Rectangle2D.Float rec = new Rectangle2D.Float(p.x - radius, p.y - radius, radius * 2, radius * 2);
        Arc2D.Float arc = new Arc2D.Float(rec, 270 - cornerNo * 60, 120.0f, 2);
        this.graphics.fill(arc);
    }

    public void drawString(Point p, int position, String s) {
        p = (Point)p.clone();
        Font font = this.graphics.getFont();
        TextLayout tl = new TextLayout(s, font, this.frc);
        Rectangle2D rec = tl.getBounds();
        int h = (int)rec.getHeight();
        int w = (int)rec.getWidth();
        switch (position) {
            case -1: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)(w / 2)));
                p.y = (int)((double)p.y - (rec.getMinY() + (double)(h / 2)));
                break;
            }
            case 0: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)(w / 2)));
                p.y = (int)((double)p.y - (rec.getMinY() + (double)h));
                break;
            }
            case 1: {
                p.x = (int)((double)p.x - rec.getMinX());
                p.y = (int)((double)p.y - (rec.getMinY() + (double)h));
                break;
            }
            case 2: {
                p.x = (int)((double)p.x - rec.getMinX());
                p.y = (int)((double)p.y - (rec.getMinY() + (double)(h / 2)));
                break;
            }
            case 3: {
                p.x = (int)((double)p.x - rec.getMinX());
                p.y = (int)((double)p.y - rec.getMinY());
                break;
            }
            case 4: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)(w / 2)));
                p.y = (int)((double)p.y - rec.getMinY());
                break;
            }
            case 5: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)w));
                p.y = (int)((double)p.y - rec.getMinY());
                break;
            }
            case 6: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)w));
                p.y = (int)((double)p.y - (rec.getMinY() + (double)(h / 2)));
                break;
            }
            case 7: {
                p.x = (int)((double)p.x - (rec.getMinX() + (double)w));
                p.y = (int)((double)p.y - (rec.getMinY() + (double)h));
            }
        }
        this.graphics.setPaint(Color.black);
        tl.draw(this.graphics, p.x, p.y);
    }

    public void drawString(Point p, int position, int border, String s) {
        p = (Point)p.clone();
        switch (position) {
            case -1: {
                break;
            }
            case 0: 
            case 1: 
            case 7: {
                p.y -= border;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                p.y += border;
            }
        }
        switch (position) {
            case -1: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                p.x += border;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                p.x -= border;
            }
        }
        this.drawString(p, position, s);
    }

    public void drawImageAndWait(Image img, int x, int y, int width, int height) {
        UtilImageObserver uio = new UtilImageObserver();
        if (this.graphics.drawImage(img, x, y, width, height, uio)) {
            return;
        }
        uio.consume();
    }

    public void drawImageAndWait(Image img, int x, int y) {
        UtilImageObserver uio = new UtilImageObserver();
        if (this.graphics.drawImage(img, x, y, uio)) {
            return;
        }
        uio.consume();
    }

    public static void waitForImage(Image img) {
        UtilImageObserver uio = new UtilImageObserver();
        while (img.getHeight(uio) == -1) {
            uio.consume();
        }
        while (img.getWidth(uio) == -1) {
            uio.consume();
        }
    }

    private static final class UtilImageObserver
    extends Semaphore
    implements ImageObserver {
        private UtilImageObserver() {
        }

        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) != 0) {
                this.produce();
                return false;
            }
            return true;
        }
    }
}

