#ifndef _OUTBOUND_HPP_
#define _OUTBOUND_HPP_
#include <stdio.h>
#include "fidoaddr.h"

#ifdef _AIX
#include "aix_conv.hpp"
#endif

#include "vars.hpp"

int SetAddToNullPkt(void);
int SetOutbound(char *tmt);
int SetTrafficLog(char *tmt);
int SetTempMail(char *tmt);
int SetKillRoutedMessages(KillModeT kmode);

typedef enum { F_DIRECT, F_CRASH, F_HOLD, F_NORMAL, F_ATTACH } PKTMode;

typedef enum { BSY, NULLPKT, PKTERROR, ATTERROR, PKTOK, NEWPKT, BADPKT } PKTrc;

class PKT {
public:
   char *BsyFile;
   FA Addr;
   PKTMode Mode;
   FILE *fh;

   PKT();
   ~PKT();
   int Set(FA &f);
   PKTrc Open(PKTMode m);
   PKTrc AddMsg(cMSG &m, PKTMode mod);
   PKTrc Poll(PKTMode mod);
   int Clean(void);
   int Bsy(void);
   void DelBsy(void);
};

void LogTraffic(cMSG &m, FA &ToAddr);
int AddToLo(char *Txt);
int DelFromLo(char *Txt);
int InitOutbound(void);
int DoRepack(void);

#endif

