/*--------------------------------------------------------------------*/
/*       U s t r . h p p                                              */
/*                                                                    */
/*       Definitions file for class "Str"                             */
/*--------------------------------------------------------------------*/
/*       Copyright (c) 2002 by Fyodor Ustinov                         */
/*                          FIDONet 2:5020/79                         */
/*                                                                    */
/*       All rights reserved.                                         */
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Own class for work witch strings. Yes. I'm crazy. :)               */
/* Some info:                                                         */
/* 1. Position returned from Pos and index in [] begin from _1_!!!    */
/*    Yes. S[1] - is a _first_ character of S.                        */
/* 2. Base(unsigned int i) - set a base for translation number to a   */
/*    string. By default Base is (Surprise! Surprise!) 10. :)         */
/*    s.Base(16); s = 10; and s now contain "a"                       */
/*                                                                    */
/**********************************************************************/

#ifndef _USTR_HPP_
#define _USTR_HPP_

#include <stddef.h>
#include <ctype.h>
#include <iostream.h>

class Str {
private:
   char *Ptr;
   unsigned long Len;
   size_t MemLen;
   unsigned int _Base;

   void alloc(size_t size);
   void free(void);
   void ParseDig(unsigned long i);
   void ParseDig(signed long i);
   void AddChar(const char c);
   
public:
   Str();
   Str(char const *Nstr);
   Str(const Str &s);
   Str & operator=(const Str &s);
   Str & operator=(const char *s);
   Str & operator=(const char c);
   ~Str();

   inline unsigned long Length(void) { return Len; };
   inline unsigned int Base(void) const { return _Base; };
   inline void Base(unsigned int i) { _Base = i; };
   Str& Trim(char const *Del = " \t");
   Str& Upper(void);
   size_t Pos(char const *s);
   Str &Cut(size_t _p, size_t _l = 0);

   Str & operator += (Str const &);
   Str & operator += (char const *);
   inline Str & operator += (char const c) { AddChar(c); return *this; };
   inline Str & operator += (signed int const i) { ParseDig((signed long)i); return *this; };
   inline Str & operator += (unsigned int const i) { ParseDig((unsigned long)i); return *this; };
   inline Str & operator += (signed long const i) { ParseDig(i); return *this; };
   inline Str & operator += (unsigned long const i) { ParseDig(i); return *this; };

   friend int operator == (Str const &, Str const &);
   friend int operator == (Str const &, char const *);
   friend int operator == (char const *, Str const &);
   friend ostream & operator << (ostream &, Str const & );

   operator char*();
   operator char const *();
   operator char const *() const;

   char & operator [] (size_t _p) ;
   char const & operator [] (size_t _p) const;

   Str operator () ( size_t _p, size_t _l = 0) const;
};



#endif