/*******************************************************************
** s y s d e p . c
** Forth Inspired Command Language
** Author: John Sadler (john_sadler@alum.mit.edu)
** Created: 16 Oct 1997
** Implementations of FICL external interface functions... 
**
** (simple) port to Linux, Skip Carter 26 March 1998
**
*******************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include "ficl.h"
#include "utils.hpp"
   

void ficlTextOut(FICL_VM *pVM, char *msg, int fNewline)
{
    FICL_IGNORE(pVM);

    ShowLogLine(msg);
    if (fNewline) ShowLogLine("\n");
    return;
}

void *ficlMalloc (size_t size)
{
    return malloc(size);
}


void  ficlFree   (void *p)
{
    free(p);
}


void *ficlRealloc(void *p, size_t size)
{
    return realloc(p, size);
}

/*
** Stub function for dictionary access control - does nothing
** by default, user can redefine to guarantee exclusive dict
** access to a single thread for updates. All dict update code
** is guaranteed to be bracketed as follows:
** ficlLockDictionary(TRUE);
** <code that updates dictionary>
** ficlLockDictionary(FALSE);
**
** Returns zero if successful, nonzero if unable to acquire lock
** befor timeout (optional - could also block forever)
*/
int ficlLockDictionary(short fLock)
{
	FICL_IGNORE(fLock);
	return 0;
}

