// -*- mode: c++; c-set-style: "stroustrup"; tab-width: 4; -*-
//
// CApp.h
//
// Copyright (C) 2004 Koji Nakamaru
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef _CApp_h_
#define _CApp_h_

class CApp {
protected:
	bool _is_dragging;
	bool _is_fullscreen;
	struct {
		int w, h;
		int x0, y0, w0, h0;
	} _view;
	struct {
		bool enable;
		unsigned long millis;
		struct timeval tv0;
	} _timer;

	CApp();
	virtual ~CApp();
	virtual void initialize(int argc, char *argv[]);
	virtual void finalize();
	virtual void display();
	virtual void reshape(int width, int height);
	virtual void menu(int value);
	virtual void key(unsigned char key, int x, int y);
	virtual void special(int key, int x, int y);
	virtual void mouse(int button, int state, int x, int y);
	virtual void drag(int x, int y);
	virtual void passive(int x, int y);
	virtual void timer(unsigned dmillis);
	void startTimer(unsigned millis);
	void stopTimer();

private:
	static void finalizeCB();
	static void displayCB();
	static void reshapeCB(int width, int height);
	static void menuCB(int value);
	static void keyCB(unsigned char key, int x, int y);
	static void specialCB(int key, int x, int y);
	static void mouseCB(int button, int state, int x, int y);
	static void motionCB(int x, int y);
	static void passiveCB(int x, int y);
	static void timerCB(int value);

	friend int main(int argc, char *argv[]);
};

#endif
