// -*- mode: c++; c-set-style: "stroustrup"; tab-width: 4; -*-
//
// common.h
//
// Copyright (C) 2004 Koji Nakamaru
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef _common_h_
#define _common_h_

#if defined(__APPLE__)
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif
#include <algorithm>
#include <vector>
#include <cassert>
#include <cctype>
#include <cerrno>
#include <cfloat>
#include <climits>
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <dirent.h>
#include <fcntl.h>
#include <map>
#include <pthread.h>
#include <stdint.h>
#include <string>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <vector>
#include "error.h"

using namespace std;

template <class T>
inline void forget(T **o)
{
    if (*o != NULL) {
		delete *o;
	}
    *o = NULL;
}

template <class T>
inline void forgetArray(T **a)
{
    if (*a != NULL) {
		delete[] *a;
	}
    *a = NULL;
}

inline void forgetFD(int *fd)
{
    if (*fd != -1) {
		close(*fd);
	}
    *fd = -1;
}

inline void forgetFILE(FILE **fp)
{
    if (*fp != NULL) {
		fclose(*fp);
	}
    *fp = NULL;
}

inline void forgetPIPE(FILE **fp)
{
    if (*fp != NULL) {
		pclose(*fp);
	}
    *fp = NULL;
}

inline void forgetDIR(DIR **dir)
{
    if (*dir != NULL) {
		closedir(*dir);
	}
    *dir = NULL;
}

template <class T>
inline T deg2rad(T angle)
{
	return angle * M_PI / 180.0;
}

template <class T>
inline T clamp(T x, T a, T b)
{
	if (x < a) {
		return a;
	} else if (x > b) {
		return b;
	}
	return x;
}

extern bool isLittleEndian();

#if defined (_WIN32) && !defined (__CYGWIN__)

#include <windows.h>

// extern int usleep(unsigned long usec);

#endif // defined (_WIN32) && !defined (__CYGWIN__)

extern void run(const char *command);

#endif
