dnl Copyright (C) 2004-2006 EDF
dnl
dnl This file is part of the FVM software package.  For license
dnl information, see the COPYING file in the top level directory of the
dnl FVM source distribution.


# FVM_AC_CONFIG_PUBL_INIT([OUPUT FILE NAME])
#-------------------------------------------
# Initialize file

AC_DEFUN([FVM_AC_CONFIG_PUBL_INIT],[

# First arg is output file name
if test "$1" = "" ; then
  fvm_ac_config_publ_h="config_publ.h"
else
  fvm_ac_config_publ_h=$1
fi
fvm_ac_lower='abcdefghijklmnopqrstuvwxyz.'
fvm_ac_upper='ABCDEFGHIJKLMNOPQRSTUVWXYZ_'
fvm_ac_config_publ_upname=`echo $fvm_ac_config_publ_h | sed y/$fvm_ac_lower/$fvm_ac_upper/`
unset fvm_ac_lower
unset fvm_ac_upper
echo "#ifndef __"${fvm_ac_config_publ_upname}"__" >  "$fvm_ac_config_publ_h"-tmp
echo "#define __"${fvm_ac_config_publ_upname}"__" >> "$fvm_ac_config_publ_h"-tmp
echo >> "$fvm_ac_config_publ_h"-tmp
echo "/* $fvm_ac_config_publ_h. Generated by configure */" >> "$fvm_ac_config_publ_h"-tmp
echo >> "$fvm_ac_config_publ_h"-tmp

AC_MSG_NOTICE([initializing $fvm_ac_config_publ_h])
])dnl


# FVM_AC_CONFIG_PUBL_FINALIZE
#----------------------------
# Finalize file

AC_DEFUN([FVM_AC_CONFIG_PUBL_FINALIZE],[

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

echo "#endif /* __"${fvm_ac_config_publ_upname}"__ */" >>  "$fvm_ac_config_publ_h"-tmp

AC_MSG_NOTICE([closing $fvm_ac_config_publ_h])

diff $fvm_ac_config_publ_h $fvm_ac_config_publ_h-tmp  > /dev/null 2>&1
if test $? -eq 0 ; then
  AC_MSG_NOTICE([$fvm_ac_config_publ_h  is unchanged])
  rm -f $fvm_ac_config_publ_h-tmp
else
  mv $fvm_ac_config_publ_h-tmp $fvm_ac_config_publ_h
fi

unset fvm_ac_config_publ_h
unset fvm_ac_config_publ_upname

])dnl


# FVM_AC_CONFIG_PUBL_VERBATIM([VERBATIM TEXT])
#---------------------------------------------
# Add text to config file

AC_DEFUN([FVM_AC_CONFIG_PUBL_VERBATIM],[

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

echo "$1" >> "$fvm_ac_config_publ_h"-tmp
echo ""   >> "$fvm_ac_config_publ_h"-tmp

])dnl


# FVM_AC_CONFIG_PUBL_DEFINE(VARIABLE NAME, VALUE, [COMMENT])
#-----------------------------------------------------------
# Define variable

AC_DEFUN([FVM_AC_CONFIG_PUBL_DEFINE],[

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

unset fvm_ac_lower
unset fvm_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$fvm_ac_config_publ_h"-tmp
fi
echo "#define $1 $2" >> "$fvm_ac_config_publ_h"-tmp
echo >> "$fvm_ac_config_publ_h"-tmp

])dnl


# FVM_AC_CONFIG_PUBL_DEFINE_STRING(VARIABLE NAME, VALUE, [COMMENT])
#------------------------------------------------------------------
# Define string variable

AC_DEFUN([FVM_AC_CONFIG_PUBL_DEFINE_STRING],[

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

unset fvm_ac_lower
unset fvm_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$fvm_ac_config_publ_h"-tmp
fi
echo '#define $1 "$2"' >> "$fvm_ac_config_publ_h"-tmp
echo >> "$fvm_ac_config_publ_h"-tmp

])dnl


# FVM_AC_CONFIG_PUBL_SET(VARIABLE NAME, YES OR NO, [COMMENT])
#------------------------------------------------------------
# Set variable (define to 1 if second arg is yes, undefine if no )

AC_DEFUN([FVM_AC_CONFIG_PUBL_SET],[

# First arg is variable name, second arg is value, optional third arg is comment

AC_REQUIRE([FVM_AC_CONFIG_PUBL_INIT])dnl

unset fvm_ac_lower
unset fvm_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$fvm_ac_config_publ_h"-tmp
fi
if test "$2" = "yes" ; then
  echo "#define $1 1" >> "$fvm_ac_config_publ_h"-tmp
else
  echo "#undef $1" >> "$fvm_ac_config_publ_h"-tmp
fi
echo >> "$fvm_ac_config_publ_h"-tmp

])dnl

