/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ExtensionImpl
implements IExtension {
    private final String myLabel;
    private final String myId;
    private final String myExtensionPointId;
    private final String myPluginId;
    private IConfigurationElement[] myConfigurationElements;

    public ExtensionImpl(String id, String label, String extensionPointId, String pluginId) {
        this.myId = id;
        this.myLabel = label;
        this.myExtensionPointId = extensionPointId;
        this.myPluginId = pluginId;
    }

    public IConfigurationElement[] getConfigurationElements() {
        return this.myConfigurationElements;
    }

    public String getExtensionPointUniqueIdentifier() {
        return this.myExtensionPointId;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getUniqueIdentifier() {
        return this.myId == null || this.myId.length() == 0 ? this.myPluginId : String.valueOf(this.myPluginId) + "." + this.myId;
    }

    public String getSimpleIdentifier() {
        return this.myId;
    }

    public String getNamespace() {
        return this.myPluginId;
    }

    public String toString() {
        return "extension: " + this.getUniqueIdentifier() + " point=" + this.myExtensionPointId;
    }

    void createConfigurationElements(NodeList configTags) {
        this.myConfigurationElements = configTags != null ? this.handleConfigurationElements(configTags, null) : new IConfigurationElement[0];
    }

    private IConfigurationElement[] handleConfigurationElements(NodeList configurationElementNodes, IConfigurationElement parentElement) {
        ArrayList<ConfigurationElementImpl> result = new ArrayList<ConfigurationElementImpl>();
        int i = 0;
        while (i < configurationElementNodes.getLength()) {
            Element element = (Element)configurationElementNodes.item(i);
            ConfigurationElementImpl configurationElement = new ConfigurationElementImpl(element.getNodeName(), element.getNodeValue());
            NamedNodeMap attrs = element.getAttributes();
            int j = 0;
            while (attrs != null && j < attrs.getLength()) {
                configurationElement.addAttribute(attrs.item(j).getNodeName(), attrs.item(j).getNodeValue());
                ++j;
            }
            configurationElement.setParent(parentElement == null ? this : parentElement);
            configurationElement.setChildren(this.handleConfigurationElements(element.getElementsByTagName("*"), configurationElement));
            result.add(configurationElement);
            ++i;
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    public class ConfigurationElementImpl
    implements IConfigurationElement {
        private HashMap myAttributes = new HashMap(5);
        private IConfigurationElement[] myChildren;
        private Object myParent;
        private final String myName;
        private final String myValue;

        ConfigurationElementImpl(String name, String value) {
            this.myName = name;
            this.myValue = value;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            Object result = null;
            Bundle bundle = Platform.getBundle(ExtensionImpl.this.myPluginId);
            if (bundle != null) {
                try {
                    Class clazz = bundle.loadClass(this.getAttribute(propertyName));
                    result = clazz == null ? null : clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new CoreException(e);
                }
                catch (InstantiationException e) {
                    throw new CoreException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CoreException(e);
                }
            }
            return result;
        }

        public String getAttribute(String name) {
            return (String)this.myAttributes.get(name);
        }

        public String[] getAttributeNames() {
            return this.myAttributes.values().toArray(new String[0]);
        }

        public IConfigurationElement[] getChildren() {
            return this.myChildren == null ? new IConfigurationElement[]{} : this.myChildren;
        }

        public IConfigurationElement[] getChildren(String name) {
            ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
            int i = 0;
            while (i < this.myChildren.length) {
                if (this.myChildren[i].getName().equals(name)) {
                    result.add(this.myChildren[i]);
                }
                ++i;
            }
            return result.toArray(new IConfigurationElement[result.size()]);
        }

        public IExtension getDeclaringExtension() {
            return ExtensionImpl.this;
        }

        public Object getParent() {
            return this.myParent;
        }

        public String getName() {
            return this.myName;
        }

        public String getValue() {
            return this.myValue;
        }

        public String toString() {
            return "configuration element: name=" + this.myName + " value=" + this.myValue + " attrs=" + this.myAttributes;
        }

        void addAttribute(String attributeName, String attributeValue) {
            this.myAttributes.put(attributeName, attributeValue);
        }

        void setParent(Object parentElement) {
            this.myParent = parentElement;
        }

        void setChildren(IConfigurationElement[] children) {
            this.myChildren = children;
        }
    }
}

