/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Page;

public class PageSequence
extends FObj {
    private static final int EXPLICIT = 0;
    private static final int AUTO = 1;
    private static final int AUTO_EVEN = 2;
    private static final int AUTO_ODD = 3;
    private Root root;
    private LayoutMasterSet layoutMasterSet;
    private HashMap flowMap;
    private Flow flow = null;
    private String masterName;
    private int firstPageNumber = 0;
    private PageNumberGenerator pageNumberGenerator;
    private int pageCount = 0;
    private int currentPageNumber;
    private int pageNumberType;
    private int forcePageCountType;
    private SimplePageMaster currentSimplePageMaster;
    private PageSequenceMaster pageSequenceMaster;

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected PageSequence(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!parent.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + parent.getName(), systemId, line, column);
        }
        this.root = (Root)parent;
        this.layoutMasterSet = this.root.getLayoutMasterSet();
        this.layoutMasterSet.checkRegionNames();
        this.flowMap = new HashMap();
        String ipnValue = this.properties.get("initial-page-number").getString();
        if (ipnValue.equals("auto")) {
            this.pageNumberType = 1;
            this.firstPageNumber = 1;
        } else if (ipnValue.equals("auto-even")) {
            this.pageNumberType = 2;
            this.firstPageNumber = 2;
        } else if (ipnValue.equals("auto-odd")) {
            this.pageNumberType = 3;
            this.firstPageNumber = 1;
        } else {
            this.pageNumberType = 0;
            try {
                int pageStart = Integer.parseInt(ipnValue);
                this.firstPageNumber = pageStart > 0 ? pageStart : 1;
            }
            catch (NumberFormatException nfe) {
                throw new FOPException("The value '" + ipnValue + "' is not valid for initial-page-number", systemId, line, column);
            }
        }
        this.masterName = this.properties.get("master-reference").getString();
        this.pageNumberGenerator = new PageNumberGenerator(this.properties.get("format").getString(), this.properties.get("grouping-separator").getCharacter(), this.properties.get("grouping-size").getNumber().intValue(), this.properties.get("letter-value").getEnum());
        this.forcePageCountType = this.properties.get("force-page-count").getEnum();
    }

    public String getName() {
        return "fo:page-sequence";
    }

    public void addFlow(Flow flow) throws FOPException {
        if (this.flow != null) {
            throw new FOPException("Only a single fo:flow permitted per fo:page-sequence", this.systemId, this.line, this.column);
        }
        if (this.flowMap.containsKey(flow.getFlowName())) {
            throw new FOPException("flow-names must be unique within an fo:page-sequence", this.systemId, this.line, this.column);
        }
        this.flow = flow;
    }

    public void addStaticContent(StaticContent staticContent) throws FOPException {
        if (this.flow != null) {
            throw new FOPException("Static content ('" + staticContent.getFlowName() + "') is not allowed after fo:flow", this.systemId, this.line, this.column);
        }
        if (this.flowMap.containsKey(staticContent.getFlowName())) {
            throw new FOPException("flow-names must be unique within an fo:page-sequence", this.systemId, this.line, this.column);
        }
        String flowName = staticContent.getFlowName();
        if (!(this.layoutMasterSet.regionNameExists(flowName) || flowName.equals("xsl-before-float-separator") || flowName.equals("xsl-footnote-separator"))) {
            this.log.error("region-name '" + staticContent.getFlowName() + "' doesn't exist in the layout-master-set.");
        }
        this.flowMap.put(staticContent.getFlowName(), staticContent);
    }

    public void format(AreaTree areaTree) throws FOPException {
        if (this.flow == null) {
            throw new FOPException("No flow in page-sequence", this.systemId, this.line, this.column);
        }
        PageSequence previousPageSequence = this.root.getPageSequence();
        if (previousPageSequence != null) {
            if (previousPageSequence.forcePageCountType == 8) {
                if (this.pageNumberType == 3) {
                    if (previousPageSequence.currentPageNumber % 2 == 0) {
                        previousPageSequence.makePage(areaTree, true, null);
                    }
                    this.currentPageNumber = previousPageSequence.currentPageNumber;
                } else if (this.pageNumberType == 2) {
                    if (previousPageSequence.currentPageNumber % 2 == 1) {
                        previousPageSequence.makePage(areaTree, true, null);
                    }
                    this.currentPageNumber = previousPageSequence.currentPageNumber;
                } else if (this.pageNumberType == 0) {
                    if (previousPageSequence.currentPageNumber % 2 != this.firstPageNumber % 2) {
                        previousPageSequence.makePage(areaTree, true, null);
                    }
                    this.currentPageNumber = this.firstPageNumber;
                } else {
                    this.currentPageNumber = previousPageSequence.currentPageNumber;
                }
            } else {
                this.currentPageNumber = previousPageSequence.currentPageNumber;
                if (this.pageNumberType == 3) {
                    if (this.currentPageNumber % 2 == 0) {
                        ++this.currentPageNumber;
                    }
                } else if (this.pageNumberType == 2) {
                    if (this.currentPageNumber % 2 == 1) {
                        ++this.currentPageNumber;
                    }
                } else if (this.pageNumberType == 0) {
                    this.currentPageNumber = this.firstPageNumber;
                }
            }
        } else {
            this.currentPageNumber = this.firstPageNumber;
        }
        previousPageSequence = null;
        this.root.setPageSequence(this);
        this.currentSimplePageMaster = this.layoutMasterSet.getSimplePageMaster(this.masterName);
        if (this.currentSimplePageMaster == null) {
            this.pageSequenceMaster = this.layoutMasterSet.getPageSequenceMaster(this.masterName);
            if (this.pageSequenceMaster == null) {
                throw new FOPException("master-reference '" + this.masterName + "' for fo:page-sequence matches no simple-page-master or page-sequence-master", this.systemId, this.line, this.column);
            }
            this.pageSequenceMaster.reset();
        } else {
            Region region = this.currentSimplePageMaster.getRegion("body");
            if (!this.flow.getFlowName().equals(region.getRegionName())) {
                throw new FOPException("Flow '" + this.flow.getFlowName() + "' does not map to the region-body in page-master '" + this.currentSimplePageMaster.getMasterName() + "'", this.systemId, this.line, this.column);
            }
        }
        int status = 1;
        Page currentPage = null;
        do {
            boolean isBlankPage = false;
            if (status == 5) {
                if (this.currentPageNumber % 2 == 1) {
                    isBlankPage = true;
                }
            } else if (status == 6 && this.currentPageNumber % 2 == 0) {
                isBlankPage = true;
            }
            currentPage = this.makePage(areaTree, isBlankPage, currentPage);
        } while (Status.isIncomplete(status = this.flow.getStatus()));
        if (this.forcePageCountType == 34) {
            if (this.pageCount % 2 != 0) {
                this.makePage(areaTree, true, null);
            }
        } else if (this.forcePageCountType == 79) {
            if (this.pageCount % 2 != 1) {
                this.makePage(areaTree, true, null);
            }
        } else if (this.forcePageCountType == 31) {
            if (this.currentPageNumber % 2 == 0) {
                this.makePage(areaTree, true, null);
            }
        } else if (this.forcePageCountType == 32 && this.currentPageNumber % 2 == 1) {
            this.makePage(areaTree, true, null);
        }
    }

    private Page makePage(AreaTree areaTree, boolean isBlankPage, Page currentPage) throws FOPException {
        if (this.pageSequenceMaster != null) {
            this.currentSimplePageMaster = this.pageSequenceMaster.getNextSimplePageMaster(this.currentPageNumber % 2 == 1, isBlankPage);
            Region region = this.currentSimplePageMaster.getRegion("body");
            if (!this.flow.getFlowName().equals(region.getRegionName())) {
                throw new FOPException("Flow '" + this.flow.getFlowName() + "' does not map to the region-body in page-master '" + this.currentSimplePageMaster.getMasterName() + "'", this.systemId, this.line, this.column);
            }
        }
        Page newPage = this.currentSimplePageMaster.getPageMaster().makePage(areaTree);
        newPage.setNumber(this.currentPageNumber);
        String formattedPageNumber = this.pageNumberGenerator.makeFormattedPageNumber(this.currentPageNumber);
        newPage.setFormattedNumber(formattedPageNumber);
        newPage.setPageSequence(this);
        if (!isBlankPage) {
            this.log.info("[" + this.currentPageNumber + "]");
            BodyAreaContainer bodyArea = newPage.getBody();
            bodyArea.setIDReferences(areaTree.getIDReferences());
            if (currentPage != null) {
                ArrayList foots = currentPage.getPendingFootnotes();
                newPage.setPendingFootnotes(foots);
            }
            this.flow.layout(bodyArea);
        } else {
            ArrayList foots;
            this.log.info("[" + this.currentPageNumber + "] (blank)");
            if (currentPage != null && (foots = currentPage.getPendingFootnotes()) != null) {
                BodyAreaContainer bodyArea = newPage.getBody();
                bodyArea.setIDReferences(areaTree.getIDReferences());
                newPage.setPendingFootnotes(foots);
            }
        }
        this.formatStaticContent(areaTree, newPage);
        areaTree.addPage(newPage);
        ++this.currentPageNumber;
        ++this.pageCount;
        return newPage;
    }

    private void formatStaticContent(AreaTree areaTree, Page page) throws FOPException {
        StaticContent staticFlow;
        SimplePageMaster simpleMaster = this.currentSimplePageMaster;
        if (simpleMaster.getRegion("before") != null && page.getBefore() != null && (staticFlow = (StaticContent)this.flowMap.get(simpleMaster.getRegion("before").getRegionName())) != null) {
            AreaContainer beforeArea = page.getBefore();
            beforeArea.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(staticFlow, simpleMaster.getRegion("before"), beforeArea);
        }
        if (simpleMaster.getRegion("after") != null && page.getAfter() != null && (staticFlow = (StaticContent)this.flowMap.get(simpleMaster.getRegion("after").getRegionName())) != null) {
            AreaContainer afterArea = page.getAfter();
            afterArea.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(staticFlow, simpleMaster.getRegion("after"), afterArea);
        }
        if (simpleMaster.getRegion("start") != null && page.getStart() != null && (staticFlow = (StaticContent)this.flowMap.get(simpleMaster.getRegion("start").getRegionName())) != null) {
            AreaContainer startArea = page.getStart();
            startArea.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(staticFlow, simpleMaster.getRegion("start"), startArea);
        }
        if (simpleMaster.getRegion("end") != null && page.getEnd() != null && (staticFlow = (StaticContent)this.flowMap.get(simpleMaster.getRegion("end").getRegionName())) != null) {
            AreaContainer endArea = page.getEnd();
            endArea.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(staticFlow, simpleMaster.getRegion("end"), endArea);
        }
    }

    private void layoutStaticContent(StaticContent flow, Region region, AreaContainer area) throws FOPException {
        flow.layout(area, region);
    }

    public StaticContent getStaticContent(String regionName) {
        return (StaticContent)this.flowMap.get(regionName);
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new PageSequence(parent, propertyList, systemId, line, column);
        }
    }
}

