/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.DynamicMockError;

public class CollectionsAcceptanceTest
extends MockObjectTestCase {
    private Mock mockT = this.mock(T.class);
    private T t = (T)this.mockT.proxy();

    public void testCanMatchArrayContainingEqualElement() {
        this.mockT.expects(this.once()).method("withArray").with(this.arrayContaining("a"));
        this.t.withArray(new String[]{"A", "a", "Aa"});
        try {
            this.t.withArray(new String[]{"B", "b", "Bb"});
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchArrayContainingMatchingElement() {
        this.mockT.expects(this.atLeastOnce()).method("withArray").with(this.arrayContaining(this.eq("a")));
        this.t.withArray(new String[]{"A", "a", "Aa"});
        try {
            this.t.withArray(new String[]{"B", "b", "Bb"});
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchElementOfArray() {
        this.mockT.expects(this.atLeastOnce()).method("withObject").with(this.isIn(new String[]{"A", "a", "Aa"}));
        this.t.withObject("a");
        try {
            this.t.withObject("not an element");
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchListContainingEqualElement() {
        this.mockT.expects(this.once()).method("withList").with(this.collectionContaining("a"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("a");
        list.add("Aa");
        this.t.withList(list);
    }

    public void testCanMatchSetContainingEqualElement() {
        this.mockT.expects(this.once()).method("withSet").with(this.collectionContaining("a"));
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("a");
        set.add("Aa");
        this.t.withSet(set);
    }

    public void testCanMatchCollectionContainingMatchingElement() {
        String string = "string";
        String equalString = new String(string);
        this.mockT.expects(this.atLeastOnce()).method("withList").with(this.collectionContaining(this.same(string)));
        this.t.withList(Collections.singletonList(string));
        try {
            this.t.withList(Collections.singletonList(equalString));
            CollectionsAcceptanceTest.fail((String)"expected DynamicMockError");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchElementOfCollection() {
        this.mockT.expects(this.atLeastOnce()).method("withObject").with(this.isIn(Arrays.asList("A", "a", "Aa")));
        this.t.withObject("a");
        try {
            this.t.withObject("not an element");
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingEntryValues() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapContaining("a", "A"));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("a", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingEntryMatchingConstraints() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapContaining(this.eq("a"), this.eq("A")));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("a", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingEqualKey() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapWithKey("a"));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("b", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingMatchingKey() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapWithKey(this.eq("a")));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("b", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingEqualValue() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapWithValue("A"));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("b", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public void testCanMatchMapContainingMatchingValue() {
        this.mockT.expects(this.atLeastOnce()).method("withMap").with(this.mapWithValue(this.eq("A")));
        HashMap<String, String> goodMap = new HashMap<String, String>();
        goodMap.put("a", "A");
        HashMap<String, String> badMap = new HashMap<String, String>();
        badMap.put("b", "B");
        this.t.withMap(goodMap);
        try {
            this.t.withMap(badMap);
            CollectionsAcceptanceTest.fail((String)"should not have been expected");
        }
        catch (DynamicMockError dynamicMockError) {
            // empty catch block
        }
    }

    public static interface T {
        public void withArray(Object[] var1);

        public void withList(List var1);

        public void withSet(Set var1);

        public void withMap(Map var1);

        public void withObject(Object var1);
    }
}

