/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

public class DynamicMockExample
extends MockObjectTestCase {
    public void testBuilderExample() {
        Mock market = this.mock(Market.class);
        Agent agent = new Agent((Market)market.proxy());
        market.stubs().method("listStocks").withNoArguments().will(this.returnValue(new String[]{"IBM", "ORCL"}));
        market.expects(this.atLeastOnce()).method("getPrice").with(this.eq("IBM")).will(this.returnValue(10));
        market.expects(this.atLeastOnce()).method("getPrice").with(this.eq("ORCL")).will(this.returnValue(25));
        market.expects(this.once()).method("buyStock").with(this.eq("IBM"), this.eq(2));
        agent.buyLowestPriceStock(20);
    }

    public void xtestDynaMockExample() {
        Mock mockMarket = this.mock(Market.class);
        Agent agent = new Agent((Market)mockMarket.proxy());
        agent.buyLowestPriceStock(1000);
    }

    public class Agent {
        Market market;

        public Agent(Market market) {
            this.market = market;
        }

        public void buyLowestPriceStock(int cost) {
            String[] stocks = this.market.listStocks();
            int cheapestPrice = Integer.MAX_VALUE;
            String cheapestStock = null;
            for (int i = 0; i < stocks.length; ++i) {
                int price = this.market.getPrice(stocks[i]);
                if (price >= cheapestPrice) continue;
                cheapestPrice = price;
                cheapestStock = stocks[i];
            }
            this.market.buyStock(cheapestStock, cost / cheapestPrice);
        }
    }

    public static interface Market {
        public String[] listStocks();

        public int getPrice(String var1);

        public void buyStock(String var1, int var2);
    }
}

