/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import junit.framework.AssertionFailedError;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.DynamicMockError;
import org.jmock.expectation.AssertMo;

public class OrderedInvocationsAcceptanceTest
extends MockObjectTestCase {
    private Mock mock;
    private ExampleInterface proxy;

    public void setUp() {
        this.mock = this.mock(ExampleInterface.class, "mock");
        this.proxy = (ExampleInterface)this.mock.proxy();
    }

    public void testOrderedCallsCanOccurInOrder() {
        this.mock.stubs().method("hello").id("hello call");
        this.mock.stubs().method("goodbye").after("hello call");
        this.proxy.hello();
        this.proxy.goodbye();
    }

    public void testOrderedCallsMustNotOccurOutOfOrder() {
        String priorCall = "HELLO-CALL-ID";
        this.mock.stubs().method("hello").id(priorCall);
        this.mock.stubs().method("goodbye").after(priorCall);
        try {
            this.proxy.goodbye();
            OrderedInvocationsAcceptanceTest.fail((String)"should have thrown DynamicMockError");
        }
        catch (DynamicMockError ex) {
            OrderedInvocationsAcceptanceTest.assertTrue((String)"error message should contain id of prior call", (ex.getMessage().indexOf(priorCall) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testOrderingDoesNotAffectUnrelatedCalls() {
        this.mock.stubs().method("hello").id("hello call");
        this.mock.stubs().method("goodbye").after("hello call");
        this.mock.stubs().method("moreTeaVicar");
        this.proxy.hello();
        this.proxy.moreTeaVicar();
        this.proxy.goodbye();
    }

    public void testOrderingConstraintsDoNotImplyExpectedCall() {
        this.mock.stubs().method("hello").isVoid().id("hello call");
        this.mock.stubs().method("goodbye").after("hello call");
    }

    public void testCanUseMethodNameAsDefaultInvocationID() {
        this.mock.stubs().method("hello").isVoid();
        this.mock.stubs().method("goodbye").after("hello");
    }

    public void testUsingSameMethodNameAsParameterToAfterIsAnError() {
        this.mock.stubs().method("count").will(this.returnValue(1));
        try {
            this.mock.stubs().method("count").after("count").will(this.returnValue(2));
        }
        catch (AssertionFailedError ex) {
            AssertMo.assertIncludes("should include repeated invokedMethod name", "count", ex.getMessage());
            return;
        }
        OrderedInvocationsAcceptanceTest.fail((String)"should have failed");
    }

    public void testCanSpecifyOrderOverDifferentMocks() {
        Mock otherMock = this.mock(ExampleInterface.class, "otherMock");
        ExampleInterface otherProxy = (ExampleInterface)otherMock.proxy();
        otherMock.stubs().method("hello").isVoid();
        this.mock.stubs().method("goodbye").after(otherMock, "hello");
        otherProxy.hello();
        this.proxy.goodbye();
    }

    public void testDetectsUnexpectedOrderOverDifferentMocks() {
        String otherMockName = "otherMock";
        String priorCall = "HELLO-CALL-ID";
        Mock otherMock = this.mock(ExampleInterface.class, otherMockName);
        otherMock.stubs().method("hello").id(priorCall);
        this.mock.stubs().method("goodbye").after(otherMock, priorCall);
        try {
            this.proxy.goodbye();
            OrderedInvocationsAcceptanceTest.fail((String)"expected DynamicMockError");
        }
        catch (DynamicMockError ex) {
            OrderedInvocationsAcceptanceTest.assertTrue((String)"error message should contain id of prior call", (ex.getMessage().indexOf(priorCall) >= 0 ? 1 : 0) != 0);
            OrderedInvocationsAcceptanceTest.assertTrue((String)"error message should contain name of mock receiving prior call", (ex.getMessage().indexOf(otherMockName) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAllowsSameInvocationMultipleTimes() {
        this.mock.stubs().method("hello").id("hello #1");
        this.mock.stubs().method("hello").after("hello #1").id("hello #2");
        this.mock.stubs().method("hello").after("hello #2").id("hello #3");
        this.mock.stubs().method("goodbye").after("hello #3");
        this.proxy.hello();
        this.proxy.hello();
        this.proxy.hello();
        this.proxy.goodbye();
    }

    public void testDetectsDuplicateIDs() {
        String duplicateID = "DUPLICATE-ID";
        this.mock.stubs().method("hello").id(duplicateID);
        try {
            this.mock.stubs().method("hello").id(duplicateID);
        }
        catch (AssertionFailedError ex) {
            AssertMo.assertIncludes("error message contains duplicate id", duplicateID, ex.getMessage());
            return;
        }
        OrderedInvocationsAcceptanceTest.fail((String)"should have failed");
    }

    public void testDetectsMissingIDs() {
        String missingID = "MISSING-ID";
        try {
            this.mock.stubs().method("hello").after(missingID);
        }
        catch (AssertionFailedError ex) {
            AssertMo.assertIncludes("error message contains missing id", missingID, ex.getMessage());
            return;
        }
        OrderedInvocationsAcceptanceTest.fail((String)"should have failed");
    }

    public void testResetClearsIDs() {
        String id = "ID";
        this.mock.stubs().method("hello").id(id);
        this.mock.reset();
        this.mock.stubs().method("goodbye").id(id);
    }

    public static interface ExampleInterface {
        public void hello();

        public void goodbye();

        public void moreTeaVicar();

        public int count();
    }
}

