/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

public class ReturnTypeAcceptanceTest
extends MockObjectTestCase {
    private Mock mock;
    private ReturnTypes proxy;

    public void setUp() {
        this.mock = this.mock(ReturnTypes.class, "theMock");
        this.proxy = (ReturnTypes)this.mock.proxy();
    }

    public void testCanReturnObjectReferences() {
        String result = new String("RESULT");
        this.mock.stubs().method("returnString").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertSame((String)"should be same result", (Object)result, (Object)this.proxy.returnString());
    }

    public void testCanReturnNullObjectReferences() {
        this.mock.stubs().method("returnString").will(this.returnValue(null));
        ReturnTypeAcceptanceTest.assertNull((String)"should be null", (Object)this.proxy.returnString());
    }

    public void testCanReturnBooleanValues() {
        this.mock.stubs().method("returnBoolean").will(this.returnValue(true));
        ReturnTypeAcceptanceTest.assertTrue((String)"should be true", (boolean)this.proxy.returnBoolean());
        this.mock.stubs().method("returnBoolean").will(this.returnValue(false));
        ReturnTypeAcceptanceTest.assertFalse((String)"should be false", (boolean)this.proxy.returnBoolean());
    }

    public void testCanReturnByteValues() {
        byte result = 123;
        this.mock.stubs().method("returnByte").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (byte)result, (byte)this.proxy.returnByte());
    }

    public void testCanReturnCharValues() {
        char result = '\u1234';
        this.mock.stubs().method("returnChar").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (char)result, (char)this.proxy.returnChar());
    }

    public void testCanReturnShortValues() {
        short result = 12345;
        this.mock.stubs().method("returnShort").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (short)result, (short)this.proxy.returnShort());
    }

    public void testCanReturnIntValues() {
        int result = 1234567890;
        this.mock.stubs().method("returnInt").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (int)result, (int)this.proxy.returnInt());
    }

    public void testCanReturnLongValues() {
        long result = 1234567890124356789L;
        this.mock.stubs().method("returnLong").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (long)result, (long)this.proxy.returnLong());
    }

    public void testCanReturnFloatValues() {
        float result = 12345.679f;
        this.mock.stubs().method("returnFloat").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (double)result, (double)this.proxy.returnFloat(), (double)0.0);
    }

    public void testCanReturnDoubleValues() {
        double result = 1.2345678901234567E9;
        this.mock.stubs().method("returnDouble").will(this.returnValue(result));
        ReturnTypeAcceptanceTest.assertEquals((String)"should be same result", (double)result, (double)this.proxy.returnDouble(), (double)0.0);
    }

    public static interface ReturnTypes {
        public String returnString();

        public boolean returnBoolean();

        public byte returnByte();

        public char returnChar();

        public short returnShort();

        public int returnInt();

        public long returnLong();

        public float returnFloat();

        public double returnDouble();
    }
}

