/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Locale;

public final class RelationType
implements ToStringRequiresFile {
    public static final int FINISH_FINISH_VALUE = 0;
    public static final int FINISH_START_VALUE = 1;
    public static final int START_FINISH_VALUE = 2;
    public static final int START_START_VALUE = 3;
    public static final RelationType FINISH_FINISH = new RelationType(0);
    public static final RelationType FINISH_START = new RelationType(1);
    public static final RelationType START_FINISH = new RelationType(2);
    public static final RelationType START_START = new RelationType(3);
    private static final RelationType[] TYPE_VALUES = new RelationType[]{FINISH_FINISH, FINISH_START, START_FINISH, START_START};
    private int m_type;

    private RelationType(int type) {
        String[] relationTypes = LocaleData.getStringArray(Locale.ENGLISH, "RELATION_TYPES");
        this.m_type = type < 0 || type >= relationTypes.length ? 1 : type;
    }

    public static RelationType getInstance(Locale locale, String type) {
        int index = -1;
        String[] relationTypes = LocaleData.getStringArray(locale, "RELATION_TYPES");
        for (int loop = 0; loop < relationTypes.length; ++loop) {
            if (!relationTypes[loop].equalsIgnoreCase(type)) continue;
            index = loop;
            break;
        }
        RelationType result = null;
        if (index != -1) {
            result = TYPE_VALUES[index];
        }
        return result;
    }

    public static RelationType getInstance(int type) {
        String[] relationTypes = LocaleData.getStringArray(Locale.ENGLISH, "RELATION_TYPES");
        if (type < 0 || type >= relationTypes.length) {
            type = 1;
        }
        return TYPE_VALUES[type];
    }

    public int getType() {
        return this.m_type;
    }

    public String toString(MPXFile mpx) {
        return this.toString(mpx.getLocale());
    }

    public String toString(Locale locale) {
        String[] typeNames = LocaleData.getStringArray(locale, "RELATION_TYPES");
        return typeNames[this.m_type];
    }

    public String toString() {
        return this.toString(Locale.ENGLISH);
    }
}

