/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGSVGElementBridge
extends SVGGElementBridge {
    public String getLocalName() {
        return "svg";
    }

    public Bridge getInstance() {
        return new SVGSVGElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        Rectangle2D r;
        String s;
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        CanvasGraphicsNode gn = new CanvasGraphicsNode();
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        boolean isOutermost = ((SVGElement)e).getOwnerSVGElement() == null;
        float x = 0.0f;
        float y = 0.0f;
        if (!isOutermost) {
            s = e.getAttributeNS(null, "x");
            if (s.length() != 0) {
                x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
            }
            if ((s = e.getAttributeNS(null, "y")).length() != 0) {
                y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
            }
        }
        if ((s = e.getAttributeNS(null, "width")).length() == 0) {
            s = "100%";
        }
        float w = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
        s = e.getAttributeNS(null, "height");
        if (s.length() == 0) {
            s = "100%";
        }
        float h = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
        gn.setVisible(CSSUtilities.convertVisibility(e));
        AffineTransform at = ViewBox.getPreserveAspectRatioTransform(e, w, h);
        float actualWidth = w;
        float actualHeight = h;
        try {
            AffineTransform atInv = at.createInverse();
            actualWidth = (float)((double)w * atInv.getScaleX());
            actualHeight = (float)((double)h * atInv.getScaleY());
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        at.preConcatenate(AffineTransform.getTranslateInstance(x, y));
        Shape clip = null;
        if (!isOutermost) {
            gn.setTransform(at);
        } else if (ctx.getDocumentSize() == null) {
            ctx.setDocumentSize(new Dimension((int)w, (int)h));
        }
        if (CSSUtilities.convertOverflow(e)) {
            float[] offsets = CSSUtilities.convertClip(e);
            clip = offsets == null ? new Rectangle2D.Float(x, y, w, h) : new Rectangle2D.Float(x + offsets[3], y + offsets[0], w - offsets[1] - offsets[3], h - offsets[2] - offsets[0]);
        }
        if (clip != null) {
            try {
                at = at.createInverse();
                clip = at.createTransformedShape(clip);
                Filter filter = gn.getGraphicsNodeRable(true);
                gn.setClip(new ClipRable8Bit(filter, clip));
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
        }
        if ((r = CSSUtilities.convertEnableBackground(e)) != null) {
            gn.setBackgroundEnable(r);
        }
        ctx.openViewport(e, new SVGSVGElementViewport((SVGSVGElement)e, actualWidth, actualHeight));
        return gn;
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        if (ctx.isDynamic()) {
            this.initializeDynamicSupport(ctx, e, node);
        }
        ctx.closeViewport(e);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("width") || attrName.equals("height") || attrName.equals("viewBox") || attrName.equals("preserveAspectRatio")) {
            CompositeGraphicsNode gn = this.node.getParent();
            gn.remove(this.node);
            AbstractGraphicsNodeBridge.disposeTree(this.e);
            this.handleElementAdded(gn, this.e.getParentNode(), this.e);
        }
    }

    public static class SVGSVGElementViewport
    implements Viewport {
        private SVGSVGElement e;
        private float width;
        private float height;

        public SVGSVGElementViewport(SVGSVGElement e, float w, float h) {
            this.e = e;
            this.width = w;
            this.height = h;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

