/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.NoRepaintRunnable;
import org.apache.batik.bridge.RepaintManager;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.UpdateTracker;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class UpdateManager
implements RunnableQueue.RunHandler {
    static final long MIN_REPAINT_TIME;
    protected BridgeContext bridgeContext;
    protected Document document;
    protected RunnableQueue updateRunnableQueue;
    protected boolean running;
    protected boolean suspendCalled;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected ScriptingEnvironment scriptingEnvironment;
    protected RepaintManager repaintManager;
    protected UpdateTracker updateTracker;
    protected GraphicsNode graphicsNode;
    protected boolean started;
    long lastRepaint = 0L;

    public static boolean isDynamicDocument(Document doc) {
        return BaseScriptingEnvironment.isDynamicDocument(doc);
    }

    public UpdateManager(BridgeContext ctx, GraphicsNode gn, Document doc) {
        this.bridgeContext = ctx;
        this.bridgeContext.setUpdateManager(this);
        this.document = doc;
        this.updateRunnableQueue = RunnableQueue.createRunnableQueue();
        this.updateRunnableQueue.setRunHandler(this);
        this.graphicsNode = gn;
        this.scriptingEnvironment = new ScriptingEnvironment(ctx);
    }

    public synchronized void dispatchSVGLoadEvent() throws InterruptedException {
        this.scriptingEnvironment.loadScripts();
        this.scriptingEnvironment.dispatchSVGLoadEvent();
    }

    public void manageUpdates(final ImageRenderer r) {
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.updateTracker = new UpdateTracker();
                    RootGraphicsNode root = UpdateManager.this.graphicsNode.getRoot();
                    if (root != null) {
                        root.addTreeGraphicsNodeChangeListener(UpdateManager.this.updateTracker);
                    }
                    UpdateManager.this.repaintManager = new RepaintManager(r);
                    UpdateManager.this.fireManagerStartedEvent();
                    UpdateManager.this.started = true;
                }
            }
        });
        this.updateRunnableQueue.resumeExecution();
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public RunnableQueue getUpdateRunnableQueue() {
        return this.updateRunnableQueue;
    }

    public RepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    public UpdateTracker getUpdateTracker() {
        return this.updateTracker;
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void suspend() {
        if (this.running) {
            this.suspendCalled = true;
            this.updateRunnableQueue.suspendExecution(false);
        }
    }

    public synchronized void resume() {
        if (!this.running) {
            this.updateRunnableQueue.resumeExecution();
        }
    }

    public synchronized void interrupt() {
        if (this.updateRunnableQueue.getThread() != null) {
            if (this.started) {
                this.dispatchSVGUnLoadEvent();
            } else {
                this.updateRunnableQueue.preemptLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        UpdateManager updateManager = UpdateManager.this;
                        synchronized (updateManager) {
                            UpdateManager.this.running = false;
                            UpdateManager.this.scriptingEnvironment.interrupt();
                            UpdateManager.this.updateRunnableQueue.getThread().interrupt();
                        }
                    }
                });
                this.resume();
            }
        }
    }

    public void dispatchSVGUnLoadEvent() {
        if (!this.started) {
            throw new IllegalStateException("UpdateManager not started.");
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    Event evt = ((DocumentEvent)((Object)UpdateManager.this.document)).createEvent("SVGEvents");
                    evt.initEvent("SVGUnload", false, false);
                    ((EventTarget)((Object)UpdateManager.this.document.getDocumentElement())).dispatchEvent(evt);
                    UpdateManager.this.running = false;
                    UpdateManager.this.scriptingEnvironment.interrupt();
                    UpdateManager.this.updateRunnableQueue.getThread().interrupt();
                    UpdateManager.this.fireManagerStoppedEvent();
                }
            }
        });
        this.resume();
    }

    public void updateRendering(AffineTransform u2d, boolean dbr, Shape aoi, int width, int height) {
        this.repaintManager.setupRenderer(u2d, dbr, aoi, width, height);
        ArrayList<Shape> l = new ArrayList<Shape>(1);
        l.add(aoi);
        this.updateRendering(l);
    }

    public void updateRendering(List areas) {
        try {
            this.fireStartedEvent(this.repaintManager.getOffScreen());
            List l = this.repaintManager.updateRendering(areas);
            this.fireCompletedEvent(this.repaintManager.getOffScreen(), l);
        }
        catch (Exception e) {
            this.fireFailedEvent();
        }
    }

    public void repaint() {
        long ctime = System.currentTimeMillis();
        if (this.updateTracker.hasChanged()) {
            List dirtyAreas;
            if (ctime - this.lastRepaint < MIN_REPAINT_TIME) {
                Iterator i = this.updateRunnableQueue.iterator();
                while (i.hasNext()) {
                    if (i.next() instanceof NoRepaintRunnable) continue;
                    return;
                }
            }
            if ((dirtyAreas = this.updateTracker.getDirtyAreas()) != null) {
                this.updateRendering(dirtyAreas);
            }
            this.updateTracker.clear();
            this.lastRepaint = System.currentTimeMillis();
        }
    }

    public void addUpdateManagerListener(UpdateManagerListener l) {
        this.listeners.add(l);
    }

    public void removeUpdateManagerListener(UpdateManagerListener l) {
        this.listeners.remove(l);
    }

    protected void fireManagerStartedEvent() {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, null, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).managerStarted(ev);
                ++i;
            }
        }
    }

    protected void fireManagerStoppedEvent() {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, null, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).managerStopped(ev);
                ++i;
            }
        }
    }

    protected void fireManagerSuspendedEvent() {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, null, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).managerSuspended(ev);
                ++i;
            }
        }
    }

    protected void fireManagerResumedEvent() {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, null, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).managerResumed(ev);
                ++i;
            }
        }
    }

    protected void fireStartedEvent(BufferedImage bi) {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, bi, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).updateStarted(ev);
                ++i;
            }
        }
    }

    protected void fireCompletedEvent(BufferedImage bi, List rects) {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, bi, rects);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).updateCompleted(ev);
                ++i;
            }
        }
    }

    protected void fireFailedEvent() {
        Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            UpdateManagerEvent ev = new UpdateManagerEvent(this, null, null);
            int i = 0;
            while (i < dll.length) {
                ((UpdateManagerListener)dll[i]).updateFailed(ev);
                ++i;
            }
        }
    }

    public void runnableInvoked(RunnableQueue rq, Runnable r) {
        if (this.running && !(r instanceof NoRepaintRunnable)) {
            this.repaint();
        }
    }

    public void executionSuspended(RunnableQueue rq) {
        if (this.suspendCalled) {
            this.running = false;
            this.fireManagerSuspendedEvent();
        }
    }

    public void executionResumed(RunnableQueue rq) {
        if (this.suspendCalled && !this.running) {
            this.running = true;
            this.suspendCalled = false;
            this.fireManagerResumedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String s = System.getProperty("org.apache.batik.min_repaint_time", "20");
        long value = 20L;
        try {
            try {
                value = Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                Object var5_3 = null;
                MIN_REPAINT_TIME = value;
            }
            Object var5_2 = null;
            MIN_REPAINT_TIME = value;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            MIN_REPAINT_TIME = value;
            throw throwable;
        }
    }
}

